/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.AllCapabilities;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.riot.system.Prefixes;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.NamedGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.TransactionHandlerView;
import org.apache.jena.system.G;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class GraphView
extends GraphBase
implements NamedGraph,
Sync {
    private final DatasetGraph dsg;
    private final Node graphName;
    private Capabilities capabilities = null;

    public static GraphView createDefaultGraph(DatasetGraph dsg) {
        return new GraphView(dsg, Quad.defaultGraphNodeGenerated);
    }

    public static GraphView createNamedGraph(DatasetGraph dsg, Node graphIRI) {
        return new GraphView(dsg, graphIRI);
    }

    public static GraphView createUnionGraph(DatasetGraph dsg) {
        return new GraphView(dsg, Quad.unionGraph);
    }

    protected GraphView(DatasetGraph dsg, Node gn) {
        this.dsg = dsg;
        this.graphName = gn;
    }

    @Override
    public Node getGraphName() {
        return this.isDefaultGraph() ? null : this.graphName;
    }

    public DatasetGraph getDataset() {
        return this.dsg;
    }

    protected final boolean isDefaultGraph() {
        return GraphView.isDefaultGraph(this.graphName);
    }

    protected final boolean isUnionGraph() {
        return GraphView.isUnionGraph(this.graphName);
    }

    protected static final boolean isDefaultGraph(Node gn) {
        return gn == null || Quad.isDefaultGraph(gn);
    }

    protected static final boolean isUnionGraph(Node gn) {
        return Quad.isUnionGraph(gn);
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        return Prefixes.adapt(this.dsg.prefixes());
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Triple m) {
        if (m == null) {
            m = Triple.ANY;
        }
        Node s = m.getMatchSubject();
        Node p = m.getMatchPredicate();
        Node o = m.getMatchObject();
        return this.graphBaseFind(s, p, o);
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Node s, Node p, Node o) {
        if (Quad.isUnionGraph(this.graphName)) {
            return this.graphUnionFind(s, p, o);
        }
        Node g = GraphView.graphNode(this.graphName);
        Iter<Triple> iter = G.quads2triples(this.dsg.find(g, s, p, o));
        return WrappedIterator.createNoRemove(iter);
    }

    private static Node graphNode(Node gn) {
        return gn == null ? Quad.defaultGraphNodeGenerated : gn;
    }

    protected ExtendedIterator<Triple> graphUnionFind(Node s, Node p, Node o) {
        Node g = GraphView.graphNode(this.graphName);
        Iterator<Quad> iterQuads = this.getDataset().find(g, s, p, o);
        Iterator<Triple> iter = G.quads2triples(iterQuads);
        iter = Iter.distinct(iter);
        return WrappedIterator.createNoRemove(iter);
    }

    @Override
    public void performAdd(Triple t) {
        Node g = GraphView.graphNode(this.graphName);
        if (Quad.isUnionGraph(g)) {
            throw new AddDeniedException("Can't update the union graph of a dataset");
        }
        Node s = t.getSubject();
        Node p = t.getPredicate();
        Node o = t.getObject();
        this.dsg.add(g, s, p, o);
    }

    @Override
    public void performDelete(Triple t) {
        Node g = GraphView.graphNode(this.graphName);
        if (Quad.isUnionGraph(g)) {
            throw new DeleteDeniedException("Can't update the union graph of a dataset");
        }
        Node s = t.getSubject();
        Node p = t.getPredicate();
        Node o = t.getObject();
        this.dsg.delete(g, s, p, o);
    }

    @Override
    public void remove(Node s, Node p, Node o) {
        if (this.getEventManager().listening()) {
            super.remove(s, p, o);
            return;
        }
        this.dsg.deleteAny(this.getGraphName(), s, p, o);
    }

    @Override
    public void clear() {
        Node gn = this.getGraphName();
        if (gn == null) {
            gn = Quad.defaultGraphNodeGenerated;
        }
        this.getDataset().deleteAny(gn, Node.ANY, Node.ANY, Node.ANY);
        this.getEventManager().notifyEvent(this, GraphEvents.removeAll);
    }

    @Override
    protected int graphBaseSize() {
        return super.graphBaseSize();
    }

    @Override
    public void sync() {
        SystemARQ.sync(this.dsg);
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return new TransactionHandlerView(this.dsg);
    }

    @Override
    public Capabilities getCapabilities() {
        return AllCapabilities.updateAllowed;
    }

    static class GraphViewException
    extends JenaException {
        public GraphViewException() {
        }

        public GraphViewException(String message) {
            super(message);
        }

        public GraphViewException(Throwable cause) {
            super(cause);
        }

        public GraphViewException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

