/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.model.element;

import java.util.Collection;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.exception.MatlabRuntimeException;
import org.eclipse.epsilon.emc.simulink.model.SimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkBlock;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkLine;
import org.eclipse.epsilon.emc.simulink.util.collection.SimulinkLineCollection;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class SimulinkPort
extends SimulinkElement {
    public SimulinkPort(SimulinkModel model, MatlabEngine engine, Double handle) throws MatlabRuntimeException {
        super(model, engine, handle);
    }

    public Collection<ISimulinkModelElement> getLines() throws EolRuntimeException {
        Object children = null;
        Object lines = null;
        try {
            this.engine.eval("handle = ?;lines = get_param(handle, 'Line');", new Object[]{this.handle});
            lines = this.engine.getVariable("lines");
        }
        catch (MatlabException e) {
            throw new EolRuntimeException(e.getMessage());
        }
        if (lines.equals(-1.0) || lines.equals(-1)) {
            return new SimulinkLineCollection(null, (SimulinkModel)this.model);
        }
        try {
            this.engine.eval("children = get_param(lines, 'LineChildren');");
            children = this.engine.getVariable("children");
            if (children != null) {
                return new SimulinkLineCollection(children, (SimulinkModel)this.model);
            }
            return new SimulinkLineCollection(lines, (SimulinkModel)this.model);
        }
        catch (Exception e) {
            throw new EolRuntimeException(e.getMessage());
        }
    }

    public SimulinkLine link(SimulinkPort other) throws EolRuntimeException {
        String parent = (String)this.getProperty("Parent");
        String parentPath = new SimulinkBlock(parent, (SimulinkModel)this.model, this.getEngine()).getParentPath();
        try {
            Double line = (Double)this.engine.evalWithResult("add_line('?',?,?);", new Object[]{parentPath, this.getHandle(), other.getHandle()});
            return new SimulinkLine((SimulinkModel)this.model, this.getEngine(), line);
        }
        catch (MatlabException e) {
            throw e.toEolRuntimeException();
        }
    }

    public void unlink(SimulinkPort other) throws EolRuntimeException {
        try {
            this.engine.eval("delete_line('?',?,?);", new Object[]{this.getHandle(), other.getHandle()});
        }
        catch (MatlabException e) {
            throw e.toEolRuntimeException();
        }
    }

    public boolean deleteElementInModel() throws EolRuntimeException {
        return false;
    }
}

