/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.services;

import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.fx.code.editor.Constants;
import org.eclipse.fx.code.editor.SourceFileInput;
import org.eclipse.fx.code.editor.StringInput;
import org.eclipse.fx.code.editor.services.StringInputAboutToChange;
import org.eclipse.fx.core.event.EventBus;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;

public class InputDocument
extends Document {
    private StringInput input;
    private IDocumentListener listener = new IDocumentListener(){

        public void documentChanged(DocumentEvent event) {
            InputDocument.this.input.updateData(event.getOffset(), event.getLength(), event.getText());
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            InputDocument.this.eventBus.publish(Constants.TOPIC_SOURCE_FILE_INPUT_TOBE_MODIFIED, (Object)new StringInputAboutToChange(InputDocument.this.input, event), true);
        }
    };
    private final EventBus eventBus;

    @Inject
    public InputDocument(@Named(value="org.eclipse.fx.code.editor.Input") StringInput input, EventBus eventBus) {
        this.input = input;
        this.eventBus = eventBus;
        this.eventBus.subscribe(Constants.TOPIC_SOURCE_FILE_RELOADED, EventBus.data(this::handleReload));
        this.set((String)input.getData());
        this.addDocumentListener(this.listener);
    }

    private void handleReload(SourceFileInput file) {
        if (this.input == file) {
            this.set((String)file.getData());
        }
    }

    public void persist() {
        this.input.setData(this.get());
        this.input.persist();
    }

    @PreDestroy
    public void dispose() {
        this.removeDocumentListener(this.listener);
    }
}

