/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.basic;

import com.sun.ts.tests.websocket.common.client.AnnotatedClientEndpoint;
import com.sun.ts.tests.websocket.common.client.BinaryAndTextClientEndpoint;
import com.sun.ts.tests.websocket.common.client.WebSocketCommonClient;
import com.sun.ts.tests.websocket.common.impl.WaitingSendHandler;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.OPS;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCBinaryClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCBinaryStreamClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCSuperEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCTextClientEndpoint;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.WSCTextStreamClientEndpoint;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class WSClientIT
extends WebSocketCommonClient {
    private static final long serialVersionUID = 7637718042723179933L;

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"wsc_ee_jakarta_websocket_remoteendpoint_usercoder_basic_web.war");
        archive.addPackages(false, Filters.exclude((Class[])new Class[]{WSClientIT.class}), new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder.basic"});
        archive.addPackages(false, new String[]{"com.sun.ts.tests.websocket.ee.jakarta.websocket.remoteendpoint.usercoder"});
        archive.addPackages(true, new String[]{"com.sun.ts.tests.websocket.common.stringbean"});
        archive.addClasses(new Class[]{WaitingSendHandler.class});
        archive.addClasses(new Class[]{IOUtil.class});
        return archive;
    }

    public WSClientIT() throws Exception {
        this.setContextRoot("wsc_ee_jakarta_websocket_remoteendpoint_usercoder_basic_web");
    }

    @Test
    public void sendObjectBooleanTextEncoderOnServerTest() throws Exception {
        this.invoke("text", OPS.BOOL, new String[]{"Anything that should have been coded has been coded into this"});
    }

    @Test
    public void sendObjectCharTextEncoderOnServerTest() throws Exception {
        this.invoke("text", OPS.CHAR, new String[]{"Anything that should have been coded has been coded into this"});
    }

    @Test
    public void sendObjectNumberTextEncoderOnServerTest() throws Exception {
        this.invoke("text", OPS.BYTE, new String[]{"Anything that should have been coded has been coded into this"});
        this.invoke("text", OPS.SHORT, new String[]{"Anything that should have been coded has been coded into this"});
        this.invoke("text", OPS.INT, new String[]{"Anything that should have been coded has been coded into this"});
        this.invoke("text", OPS.LONG, new String[]{"Anything that should have been coded has been coded into this"});
        this.invoke("text", OPS.FLOAT, new String[]{"Anything that should have been coded has been coded into this"});
        this.invoke("text", OPS.DOUBLE, new String[]{"Anything that should have been coded has been coded into this"});
    }

    @Test
    public void sendObjectBooleanTextEncoderOnClientTest() throws Exception {
        WSCTextClientEndpoint client = new WSCTextClientEndpoint();
        this.setAnnotatedClientEndpointInstance((AnnotatedClientEndpoint)client);
        this.invoke("echo", true, new String[]{"Anything that should have been coded has been coded into this"});
    }

    @Test
    public void sendObjectCharTextEncoderOnClientTest() throws Exception {
        WSCTextClientEndpoint client = new WSCTextClientEndpoint();
        this.setAnnotatedClientEndpointInstance((AnnotatedClientEndpoint)client);
        this.invoke("echo", Character.valueOf('1'), new String[]{"Anything that should have been coded has been coded into this"});
    }

    @Test
    public void sendObjectNumberTextEncoderOnClientTest() throws Exception {
        WSCTextClientEndpoint client = new WSCTextClientEndpoint();
        this.setAnnotatedClientEndpointInstance((AnnotatedClientEndpoint)client);
        this.invoke("echo", WSCSuperEndpoint.NUMERIC, new String[]{"Anything that should have been coded has been coded into this"});
        this.setAnnotatedClientEndpointInstance((AnnotatedClientEndpoint)client);
        this.invoke("echo", WSCSuperEndpoint.NUMERIC.shortValue(), new String[]{"Anything that should have been coded has been coded into this"});
        this.setAnnotatedClientEndpointInstance((AnnotatedClientEndpoint)client);
        this.invoke("echo", WSCSuperEndpoint.NUMERIC.intValue(), new String[]{"Anything that should have been coded has been coded into this"});
        this.setAnnotatedClientEndpointInstance((AnnotatedClientEndpoint)client);
        this.invoke("echo", WSCSuperEndpoint.NUMERIC.longValue(), new String[]{"Anything that should have been coded has been coded into this"});
        this.setAnnotatedClientEndpointInstance((AnnotatedClientEndpoint)client);
        this.invoke("echo", WSCSuperEndpoint.NUMERIC.doubleValue(), new String[]{"Anything that should have been coded has been coded into this"});
        this.setAnnotatedClientEndpointInstance((AnnotatedClientEndpoint)client);
        this.invoke("echo", Float.valueOf(WSCSuperEndpoint.NUMERIC.floatValue()), new String[]{"Anything that should have been coded has been coded into this"});
    }

    @Test
    public void sendObjectPrimitivesTextStreamEncoderOnServerTest() throws Exception {
        for (OPS op : OPS.values()) {
            this.invoke("textstream", op, new String[]{"Anything that should have been coded has been coded into this"});
        }
    }

    @Test
    public void sendObjectPrimitivesTextStreamEncoderOnClientTest() throws Exception {
        WSCTextStreamClientEndpoint client = new WSCTextStreamClientEndpoint();
        for (Object entity : OPS.getClientEntities()) {
            this.setAnnotatedClientEndpointInstance((AnnotatedClientEndpoint)client);
            this.invoke("echo", entity, new String[]{"Anything that should have been coded has been coded into this"});
        }
    }

    @Test
    public void sendObjectPrimitivesBinaryEncoderOnServerTest() throws Exception {
        for (OPS op : OPS.values()) {
            this.setClientEndpoint(BinaryAndTextClientEndpoint.class);
            this.invoke("binary", op, new String[]{"Anything that should have been coded has been coded into this"});
        }
    }

    @Test
    public void sendObjectPrimitivesBinaryEncoderOnClientTest() throws Exception {
        WSCBinaryClientEndpoint client = new WSCBinaryClientEndpoint();
        for (Object entity : OPS.getClientEntities()) {
            this.setAnnotatedClientEndpointInstance((AnnotatedClientEndpoint)client);
            this.invoke("echo", entity, new String[]{"Anything that should have been coded has been coded into this"});
        }
    }

    @Test
    public void sendObjectPrimitivesBinaryStreamEncoderOnServerTest() throws Exception {
        for (OPS op : OPS.values()) {
            this.setClientEndpoint(BinaryAndTextClientEndpoint.class);
            this.invoke("binarystream", op, new String[]{"Anything that should have been coded has been coded into this"});
        }
    }

    @Test
    public void sendObjectPrimitivesBinaryStreamEncoderOnClientTest() throws Exception {
        WSCBinaryStreamClientEndpoint client = new WSCBinaryStreamClientEndpoint();
        for (Object entity : OPS.getClientEntities()) {
            this.setAnnotatedClientEndpointInstance((AnnotatedClientEndpoint)client);
            this.invoke("echo", entity, new String[]{"Anything that should have been coded has been coded into this"});
        }
    }
}

