/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.util.function.Supplier;

public abstract class Holder<E> {
    public static <T> Holder<T> staticHolder(final T value) {
        return new Holder<T>(){

            @Override
            public T get() {
                return value;
            }
        };
    }

    public static IntHolder staticIntHolder(final int value) {
        return new IntHolder(){

            @Override
            public int getInt() {
                return value;
            }
        };
    }

    public static <T> LazyHolder<T> lazyHolder(final Supplier<T> factory) {
        return new LazyHolder<T>(){

            @Override
            protected T evaluate() {
                return factory.get();
            }
        };
    }

    public static LazyIntHolder lazyIntHolder(final Supplier<Integer> factory) {
        return new LazyIntHolder(){

            @Override
            protected int evaluate() {
                return (Integer)factory.get();
            }
        };
    }

    public abstract E get();

    public String toString() {
        E obj = this.get();
        return obj != null ? "{" + String.valueOf(obj) + "}" : "{}";
    }

    public static abstract class LazyIntHolder
    extends IntHolder {
        private volatile boolean isSet;
        private int value;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final int getInt() {
            if (this.isSet) {
                return this.value;
            }
            LazyIntHolder lazyIntHolder = this;
            synchronized (lazyIntHolder) {
                if (!this.isSet) {
                    this.value = this.evaluate();
                    this.isSet = true;
                }
            }
            return this.value;
        }

        protected abstract int evaluate();
    }

    public static abstract class IntHolder
    extends Holder<Integer> {
        @Override
        public final Integer get() {
            return this.getInt();
        }

        public abstract int getInt();
    }

    public static abstract class LazyHolder<E>
    extends Holder<E> {
        private volatile boolean isSet;
        private E value;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final E get() {
            if (this.isSet) {
                return this.value;
            }
            LazyHolder lazyHolder = this;
            synchronized (lazyHolder) {
                if (!this.isSet) {
                    this.value = this.evaluate();
                    this.isSet = true;
                }
            }
            return this.value;
        }

        protected abstract E evaluate();
    }
}

