/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.attributes;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.DefaultAttributeBuilder;
import org.glassfish.grizzly.attributes.IndexedAttributeAccessor;

public class IndexedMapAttributeHolder
implements AttributeHolder {
    private final ConcurrentMap<Integer, Object> valueMap = new ConcurrentHashMap<Integer, Object>();
    private final IndexedAttributeAccessor indexedAttributeAccessor = new IndexedAttributeAccessorImpl();
    private final DefaultAttributeBuilder attributeBuilder;

    IndexedMapAttributeHolder(AttributeBuilder attributeBuilder) {
        this.attributeBuilder = (DefaultAttributeBuilder)attributeBuilder;
    }

    @Override
    public Object getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    @Override
    public Object getAttribute(String name, Supplier initializer) {
        Attribute attribute = this.attributeBuilder.getAttributeByName(name);
        if (attribute != null) {
            return this.indexedAttributeAccessor.getAttribute(attribute.index(), initializer);
        }
        return initializer != null ? initializer.get() : null;
    }

    @Override
    public void setAttribute(String name, Object value) {
        Attribute attribute = this.attributeBuilder.getAttributeByName(name);
        if (attribute == null) {
            attribute = this.attributeBuilder.createAttribute(name);
        }
        this.indexedAttributeAccessor.setAttribute(attribute.index(), value);
    }

    @Override
    public Object removeAttribute(String name) {
        Attribute attribute = this.attributeBuilder.getAttributeByName(name);
        if (attribute != null) {
            return this.indexedAttributeAccessor.removeAttribute(attribute.index());
        }
        return null;
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.valueMap.keySet().stream().map(index -> this.attributeBuilder.getAttributeByIndex((int)index).name()).collect(Collectors.toSet());
    }

    @Override
    public void copyFrom(AttributeHolder srcAttributes) {
        if (srcAttributes == null) {
            return;
        }
        this.clear();
        if (srcAttributes instanceof IndexedMapAttributeHolder) {
            IndexedMapAttributeHolder imah = (IndexedMapAttributeHolder)srcAttributes;
            this.valueMap.putAll(imah.valueMap);
        } else {
            srcAttributes.getAttributeNames().forEach(name -> this.setAttribute((String)name, srcAttributes.getAttribute((String)name)));
        }
    }

    @Override
    public void copyTo(AttributeHolder dstAttributes) {
        if (dstAttributes == null) {
            return;
        }
        if (dstAttributes instanceof IndexedMapAttributeHolder) {
            IndexedMapAttributeHolder imah = (IndexedMapAttributeHolder)dstAttributes;
            imah.valueMap.clear();
            imah.valueMap.putAll(this.valueMap);
        } else {
            dstAttributes.clear();
            this.valueMap.forEach((index, value) -> dstAttributes.setAttribute(this.attributeBuilder.getAttributeByIndex((int)index).name(), value));
        }
    }

    @Override
    public void recycle() {
        this.clear();
    }

    @Override
    public void clear() {
        this.valueMap.clear();
    }

    @Override
    public AttributeBuilder getAttributeBuilder() {
        return this.attributeBuilder;
    }

    @Override
    public IndexedAttributeAccessor getIndexedAttributeAccessor() {
        return this.indexedAttributeAccessor;
    }

    private final class IndexedAttributeAccessorImpl
    implements IndexedAttributeAccessor {
        private IndexedAttributeAccessorImpl() {
        }

        @Override
        public Object getAttribute(int index) {
            return this.getAttribute(index, null);
        }

        @Override
        public Object getAttribute(int index, Supplier initializer) {
            return IndexedMapAttributeHolder.this.valueMap.computeIfAbsent(index, arg_0 -> IndexedAttributeAccessorImpl.lambda$getAttribute$0((Supplier)initializer, arg_0));
        }

        @Override
        public void setAttribute(int index, Object value) {
            if (value != null) {
                IndexedMapAttributeHolder.this.valueMap.put(index, value);
            } else {
                IndexedMapAttributeHolder.this.valueMap.remove(index);
            }
        }

        @Override
        public Object removeAttribute(int index) {
            return IndexedMapAttributeHolder.this.valueMap.remove(index);
        }

        private static /* synthetic */ Object lambda$getAttribute$0(Supplier initializer, Integer k) {
            return initializer != null ? initializer.get() : null;
        }
    }
}

