/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jdke.props;

public final class SystemProperties {
    private static final System.Logger LOG = System.getLogger(SystemProperties.class.getName());

    private SystemProperties() {
    }

    public static String setProperty(String key, String value, boolean force) {
        String oldValue = System.getProperty(key);
        if (oldValue == null) {
            LOG.log(System.Logger.Level.DEBUG, "Setting property {0} to {1}", key, value);
        } else {
            if (oldValue.equals(value)) {
                LOG.log(System.Logger.Level.TRACE, "Property {0} already set to the same value {1}", key, oldValue);
                return oldValue;
            }
            if (force) {
                LOG.log(System.Logger.Level.WARNING, "Property {0} already set to {1}, overriding with {2}", key, oldValue, value);
            } else {
                LOG.log(System.Logger.Level.WARNING, "Property {0} already set to {1}, not overriding with {2}", key, oldValue, value);
                return oldValue;
            }
        }
        if (value == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
        return oldValue;
    }
}

