/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.configprovider;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.facelets.util.Classpath;
import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaInfFacesConfigResourceProvider
implements ConfigurationResourceProvider {
    private static final Pattern JAR_PATTERN = Pattern.compile(".*/(\\S*\\.jar).*");
    private static final String META_INF_RESOURCES = "META-INF/faces-config.xml";
    private static final String WEB_INF_CLASSES = "/WEB-INF/classes/META-INF";
    private static final String FACES_CONFIG_EXTENSION = ".faces-config.xml";

    @Override
    public Collection<URI> getResources(ServletContext context) {
        WebConfiguration webConfig = WebConfiguration.getInstance(context);
        String duplicateJarPattern = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.DuplicateJARPattern);
        Pattern duplicatePattern = null;
        if (duplicateJarPattern != null) {
            duplicatePattern = Pattern.compile(duplicateJarPattern);
        }
        TreeMap<String, Set> sortedJarMap = new TreeMap<String, Set>();
        ArrayList<URI> unsortedResourceList = new ArrayList<URI>();
        try {
            for (URI uri : this.loadURLs(context)) {
                String jarUrl = uri.toString();
                String jarName = null;
                Matcher m = JAR_PATTERN.matcher(jarUrl);
                if (m.matches()) {
                    jarName = m.group(1);
                }
                if (jarName != null) {
                    if (duplicatePattern != null && (m = duplicatePattern.matcher(jarName)).matches()) {
                        jarName = m.group(1);
                    }
                    Set uris = sortedJarMap.computeIfAbsent(jarName, k -> new HashSet());
                    uris.add(uri);
                    continue;
                }
                unsortedResourceList.add(0, uri);
            }
        }
        catch (IOException e) {
            throw new FacesException(e);
        }
        ArrayList<URI> result = new ArrayList<URI>(sortedJarMap.size() + unsortedResourceList.size());
        for (Map.Entry entry : sortedJarMap.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        result.addAll(unsortedResourceList);
        return result;
    }

    private Collection<URI> loadURLs(ServletContext context) throws IOException {
        HashSet<URI> urls = new HashSet<URI>();
        try {
            String urlString;
            URL[] urlArray;
            Enumeration<URL> e = Util.getCurrentLoader(this).getResources(META_INF_RESOURCES);
            while (e.hasMoreElements()) {
                String string2 = e.nextElement().toExternalForm();
                string2 = string2.replace(" ", "%20");
                urls.add(new URI(string2));
            }
            for (URL cur : urlArray = Classpath.search("META-INF/", FACES_CONFIG_EXTENSION)) {
                urlString = cur.toExternalForm();
                urlString = urlString.replace(" ", "%20");
                urls.add(new URI(urlString));
            }
            Set set = context.getResourcePaths(WEB_INF_CLASSES);
            if (set != null) {
                for (Object path : set) {
                    String p = path.toString();
                    if (!p.endsWith(FACES_CONFIG_EXTENSION)) continue;
                    urlString = context.getResource(p).toExternalForm();
                    urlString = urlString.replace(" ", "%20");
                    urls.add(new URI(urlString));
                }
            }
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        return urls;
    }
}

