/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import org.glassfish.grizzly.http.Cookies;
import org.glassfish.grizzly.http.LazyCookieState;

public class CookieHeaderParser {
    private static final boolean[] isCookieOctet;
    private static final boolean[] isText;
    private static final byte[] EMPTY_BYTES;
    private static final byte TAB_BYTE = 9;
    private static final byte SPACE_BYTE = 32;
    private static final byte QUOTE_BYTE = 34;
    private static final byte COMMA_BYTE = 44;
    private static final byte SEMICOLON_BYTE = 59;
    private static final byte EQUALS_BYTE = 61;
    private static final byte SLASH_BYTE = 92;
    private static final byte DEL_BYTE = 127;
    private static final int ARRAY_SIZE = 128;
    private static final boolean[] IS_CONTROL;
    private static final boolean[] IS_SEPARATOR;
    private static final boolean[] IS_TOKEN;

    private CookieHeaderParser() {
    }

    public static void parseCookie(byte[] bytes, int offset, int len, Cookies serverCookies) {
        ByteBuffer byteBuffer = new ByteBuffer(bytes, offset, len);
        boolean moreToProcess = true;
        while (moreToProcess) {
            CookieHeaderParser.skipWhiteSpace(byteBuffer);
            ByteBuffer name = CookieHeaderParser.readToken(byteBuffer);
            ByteBuffer value = null;
            CookieHeaderParser.skipWhiteSpace(byteBuffer);
            SkipResult skipResult = CookieHeaderParser.skipByte(byteBuffer, (byte)61);
            if (skipResult == SkipResult.FOUND) {
                CookieHeaderParser.skipWhiteSpace(byteBuffer);
                value = CookieHeaderParser.readCookieValueRfc6265(byteBuffer);
                if (value == null) {
                    CookieHeaderParser.skipUntilSemiColon(byteBuffer);
                    continue;
                }
                CookieHeaderParser.skipWhiteSpace(byteBuffer);
            }
            if ((skipResult = CookieHeaderParser.skipByte(byteBuffer, (byte)59)) != SkipResult.FOUND) {
                if (skipResult == SkipResult.NOT_FOUND) {
                    CookieHeaderParser.skipUntilSemiColon(byteBuffer);
                    continue;
                }
                moreToProcess = false;
            }
            if (!name.hasRemaining()) continue;
            LazyCookieState lazyCookie = serverCookies.getNextUnusedCookie().getLazyCookieState();
            lazyCookie.getName().setBytes(name.array(), name.position(), name.position() + name.remaining());
            if (value == null) {
                lazyCookie.getValue().setBytes(EMPTY_BYTES, 0, EMPTY_BYTES.length);
                continue;
            }
            lazyCookie.getValue().setBytes(value.array(), value.position(), value.position() + value.remaining());
        }
    }

    private static void skipWhiteSpace(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining()) {
            byte b = byteBuffer.get();
            if (b == 9 || b == 32) continue;
            byteBuffer.rewind();
            break;
        }
    }

    private static void skipUntilSemiColon(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining() && byteBuffer.get() != 59) {
        }
    }

    private static SkipResult skipByte(ByteBuffer byteBuffer, byte target) {
        if (!byteBuffer.hasRemaining()) {
            return SkipResult.EOF;
        }
        if (byteBuffer.get() == target) {
            return SkipResult.FOUND;
        }
        byteBuffer.rewind();
        return SkipResult.NOT_FOUND;
    }

    private static ByteBuffer readCookieValueRfc6265(ByteBuffer byteBuffer) {
        boolean quoted = false;
        int cookieValueStart = byteBuffer.position();
        int cookieValueEnd = byteBuffer.limit();
        while (byteBuffer.hasRemaining()) {
            byte byteFromBuffer = byteBuffer.get();
            if (isCookieOctet[byteFromBuffer & 0xFF]) continue;
            if (byteFromBuffer == 59 || byteFromBuffer == 32 || byteFromBuffer == 9) {
                cookieValueEnd = byteBuffer.position() - 1;
                byteBuffer.position(cookieValueEnd);
                break;
            }
            if (byteFromBuffer == 34 && cookieValueStart == byteBuffer.position() - 1) {
                quoted = true;
                continue;
            }
            if (quoted && byteFromBuffer == 34) {
                cookieValueEnd = byteBuffer.position();
                break;
            }
            return null;
        }
        return new ByteBuffer(byteBuffer.bytes, cookieValueStart, cookieValueEnd - cookieValueStart);
    }

    private static ByteBuffer readToken(ByteBuffer byteBuffer) {
        int start = byteBuffer.position();
        int end = byteBuffer.limit();
        while (byteBuffer.hasRemaining()) {
            if (CookieHeaderParser.isToken(byteBuffer.get())) continue;
            end = byteBuffer.position() - 1;
            byteBuffer.position(end);
            break;
        }
        return new ByteBuffer(byteBuffer.bytes, start, end - start);
    }

    public static boolean isToken(int c) {
        try {
            return IS_TOKEN[c];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
    }

    static {
        int i;
        isCookieOctet = new boolean[256];
        isText = new boolean[256];
        EMPTY_BYTES = new byte[0];
        IS_CONTROL = new boolean[128];
        IS_SEPARATOR = new boolean[128];
        IS_TOKEN = new boolean[128];
        for (i = 0; i < 256; ++i) {
            CookieHeaderParser.isCookieOctet[i] = i >= 33 && i != 34 && i != 44 && i != 59 && i != 92 && i != 127;
        }
        for (i = 0; i < 256; ++i) {
            CookieHeaderParser.isText[i] = i >= 9 && (i <= 9 || i >= 32) && i != 127;
        }
        for (i = 0; i < 128; ++i) {
            if (i < 32 || i == 127) {
                CookieHeaderParser.IS_CONTROL[i] = true;
            }
            if (i == 40 || i == 41 || i == 60 || i == 62 || i == 64 || i == 44 || i == 59 || i == 58 || i == 92 || i == 34 || i == 47 || i == 91 || i == 93 || i == 63 || i == 61 || i == 123 || i == 125 || i == 32 || i == 9) {
                CookieHeaderParser.IS_SEPARATOR[i] = true;
            }
            if (IS_CONTROL[i] || IS_SEPARATOR[i] || i >= 128) continue;
            CookieHeaderParser.IS_TOKEN[i] = true;
        }
    }

    private static class ByteBuffer {
        private final byte[] bytes;
        private int limit;
        private int position = 0;

        public ByteBuffer(byte[] bytes, int offset, int len) {
            this.bytes = bytes;
            this.position = offset;
            this.limit = offset + len;
        }

        public int position() {
            return this.position;
        }

        public void position(int position) {
            this.position = position;
        }

        public int limit() {
            return this.limit;
        }

        public int remaining() {
            return this.limit - this.position;
        }

        public boolean hasRemaining() {
            return this.position < this.limit;
        }

        public byte get() {
            return this.bytes[this.position++];
        }

        public void rewind() {
            --this.position;
        }

        public byte[] array() {
            return this.bytes;
        }

        public String toString() {
            return "position [" + this.position + "], limit [" + this.limit + "]";
        }
    }

    private static enum SkipResult {
        FOUND,
        NOT_FOUND,
        EOF;

    }
}

