/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.glassfish.rmic.Main;
import org.glassfish.rmic.tools.java.ClassPath;

public class BatchEnvironment
extends org.glassfish.rmic.tools.javac.BatchEnvironment {
    private File destinationDir;
    private Vector<File> generatedFiles = new Vector();

    public static ClassPath createClassPath(String classPathString, String sysClassPathString) {
        Path path = new Path();
        if (sysClassPathString == null) {
            sysClassPathString = System.getProperty("sun.boot.class.path");
        }
        if (sysClassPathString != null) {
            path.addFiles(sysClassPathString);
        }
        path.expandJarClassPaths(true);
        path.emptyPathDefault(".");
        if (classPathString == null && (classPathString = System.getProperty("env.class.path")) == null) {
            classPathString = ".";
        }
        path.addFiles(classPathString);
        return new ClassPath(path.toArray(new String[path.size()]));
    }

    public BatchEnvironment(OutputStream out, ClassPath path, File destinationDir) {
        super(out, path);
        this.destinationDir = destinationDir;
    }

    public File getDestinationDir() {
        return this.destinationDir;
    }

    public ClassPath getClassPath() {
        return this.binaryPath;
    }

    public void addGeneratedFile(File file) {
        this.generatedFiles.addElement(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteGeneratedFiles() {
        Vector<File> vector = this.generatedFiles;
        synchronized (vector) {
            Enumeration<File> enumeration = this.generatedFiles.elements();
            while (enumeration.hasMoreElements()) {
                File file = enumeration.nextElement();
                file.delete();
            }
            this.generatedFiles.removeAllElements();
        }
    }

    @Override
    public void shutdown() {
        this.generatedFiles = null;
        super.shutdown();
    }

    @Override
    public String errorString(String err, Object arg0, Object arg1, Object arg2) {
        if (err.startsWith("rmic.") || err.startsWith("warn.rmic.")) {
            Object result = Main.getText(err, arg0 != null ? arg0.toString() : null, arg1 != null ? arg1.toString() : null, arg2 != null ? arg2.toString() : null);
            if (err.startsWith("warn.")) {
                result = "warning: " + (String)result;
            }
            return result;
        }
        return super.errorString(err, arg0, arg1, arg2);
    }

    public void reset() {
    }

    private static class Path
    extends LinkedHashSet<String> {
        private static final long serialVersionUID = 0L;
        private static final boolean warn = false;
        private boolean expandJarClassPaths = false;
        private String emptyPathDefault = null;

        private static boolean isZip(String name) {
            return new File(name).isFile();
        }

        public Path expandJarClassPaths(boolean x) {
            this.expandJarClassPaths = x;
            return this;
        }

        public Path emptyPathDefault(String x) {
            this.emptyPathDefault = x;
            return this;
        }

        public Path addDirectories(String dirs, boolean warn) {
            if (dirs != null) {
                for (String dir : new PathIterator(dirs)) {
                    this.addDirectory(dir, warn);
                }
            }
            return this;
        }

        public Path addDirectories(String dirs) {
            return this.addDirectories(dirs, false);
        }

        private void addDirectory(String dir, boolean warn) {
            if (!new File(dir).isDirectory()) {
                return;
            }
            for (String direntry : new File(dir).list()) {
                String canonicalized = direntry.toLowerCase();
                if (!canonicalized.endsWith(".jar") && !canonicalized.endsWith(".zip")) continue;
                this.addFile(dir + File.separator + direntry, warn);
            }
        }

        public Path addFiles(String files, boolean warn) {
            if (files != null) {
                for (String file : new PathIterator(files, this.emptyPathDefault)) {
                    this.addFile(file, warn);
                }
            }
            return this;
        }

        public Path addFiles(String files) {
            return this.addFiles(files, false);
        }

        private void addFile(String file, boolean warn) {
            String arcname;
            if (this.contains(file)) {
                return;
            }
            File ele = new File(file);
            if (!ele.exists() && warn) {
                return;
            }
            if (ele.isFile() && !(arcname = file.toLowerCase()).endsWith(".zip") && !arcname.endsWith(".jar")) {
                return;
            }
            super.add(file);
            if (this.expandJarClassPaths && Path.isZip(file)) {
                this.addJarClassPath(file, warn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addJarClassPath(String jarFileName, boolean warn) {
            try {
                String jarParent = new File(jarFileName).getParent();
                try (JarFile jar = new JarFile(jarFileName);){
                    Manifest man = jar.getManifest();
                    if (man == null) {
                        return;
                    }
                    Attributes attr = man.getMainAttributes();
                    if (attr == null) {
                        return;
                    }
                    String path = attr.getValue(Attributes.Name.CLASS_PATH);
                    if (path == null) {
                        return;
                    }
                    StringTokenizer st = new StringTokenizer(path);
                    while (st.hasMoreTokens()) {
                        String elt = st.nextToken();
                        if (jarParent != null) {
                            elt = new File(jarParent, elt).getCanonicalPath();
                        }
                        this.addFile(elt, warn);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static class PathIterator
        implements Collection<String> {
            private int pos = 0;
            private final String path;
            private final String emptyPathDefault;

            public PathIterator(String path, String emptyPathDefault) {
                this.path = path;
                this.emptyPathDefault = emptyPathDefault;
            }

            public PathIterator(String path) {
                this(path, null);
            }

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return pos <= path.length();
                    }

                    @Override
                    public String next() {
                        int beg = pos;
                        int end = path.indexOf(File.pathSeparator, beg);
                        if (end == -1) {
                            end = path.length();
                        }
                        pos = end + 1;
                        if (beg == end && emptyPathDefault != null) {
                            return emptyPathDefault;
                        }
                        return path.substring(beg, end);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isEmpty() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean contains(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean add(String o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends String> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean equals(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int hashCode() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

