/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.interfaces.MailResourceIntf;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.repository.ResourceProperty;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MailConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = DOLUtils.getDefaultLogger();
    private static final String PROP_NAME_PREFIX_LEGACY = "mail-";
    private static final char PROP_NAME_DELIM_LEGACY = '-';
    private static final String MAIL_STORE_PROTOCOL = "mail.store.protocol";
    private static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    private static final String MAIL_HOST = "mail.host";
    private static final String MAIL_USER = "mail.user";
    private static final String MAIL_FROM = "mail.from";
    private static final String MAIL_DEBUG = "mail.debug";
    private static final String MAIL_PREFIX = "mail.";
    private static final String MAIL_SUFFIX_CLASS = ".class";
    private static final char MAIL_DELIM = '.';
    private String description = "";
    private String jndiName = "";
    private boolean enabled;
    private String storeProtocol;
    private String storeProtocolClass;
    private String transportProtocol;
    private String transportProtocolClass;
    private String mailHost;
    private String username;
    private String mailFrom;
    private boolean debug;
    private final Properties mailProperties = new Properties();

    public MailConfiguration(String username, String mailFrom, String mailHost) {
        this.username = username;
        this.mailFrom = mailFrom;
        this.mailHost = mailHost;
        this.put(MAIL_FROM, mailFrom);
        this.put(MAIL_USER, username);
        this.put(MAIL_HOST, mailHost);
    }

    public MailConfiguration(MailResourceIntf mailRes) {
        try {
            this.loadMailResources(mailRes);
        }
        catch (Exception ce) {
            LOG.log(Level.INFO, "enterprise.deployment_mail_cfgexcp", ce);
        }
    }

    private void loadMailResources(MailResourceIntf mailResource) throws Exception {
        if (mailResource == null) {
            LOG.log(Level.FINE, "MailConfiguration: no MailResource object. mailResource is null");
            return;
        }
        this.jndiName = mailResource.getName();
        this.description = mailResource.getDescription();
        this.enabled = mailResource.isEnabled();
        this.storeProtocol = mailResource.getStoreProtocol();
        this.storeProtocolClass = mailResource.getStoreProtocolClass();
        this.transportProtocol = mailResource.getTransportProtocol();
        this.transportProtocolClass = mailResource.getTransportProtocolClass();
        this.mailHost = mailResource.getMailHost();
        this.username = mailResource.getUsername();
        this.mailFrom = mailResource.getMailFrom();
        this.debug = mailResource.isDebug();
        if (this.transportProtocol == null) {
            this.transportProtocol = "smtp";
        }
        this.put(MAIL_HOST, this.mailHost);
        this.put(MAIL_USER, this.username);
        this.put(MAIL_STORE_PROTOCOL, this.storeProtocol);
        this.put(MAIL_TRANSPORT_PROTOCOL, this.transportProtocol);
        if (this.storeProtocol != null) {
            this.put(MAIL_PREFIX + this.storeProtocol + MAIL_SUFFIX_CLASS, this.storeProtocolClass);
        }
        if (this.transportProtocol != null) {
            this.put(MAIL_PREFIX + this.transportProtocol + MAIL_SUFFIX_CLASS, this.transportProtocolClass);
        }
        this.put(MAIL_FROM, this.mailFrom);
        this.put(MAIL_DEBUG, this.debug ? "true" : "false");
        Set<ResourceProperty> properties = mailResource.getProperties();
        for (ResourceProperty property : properties) {
            String name = property.getName();
            String value = property.getValue();
            if (name.startsWith(PROP_NAME_PREFIX_LEGACY)) {
                name = name.replace('-', '.');
            }
            this.put(name, value);
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("mail property: " + name + " = " + value);
        }
    }

    private void put(String name, String value) {
        if (value != null && !value.isEmpty()) {
            this.mailProperties.put(name, value);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getMailFrom() {
        return this.mailFrom;
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public String getMailStoreProtocol() {
        return this.storeProtocol;
    }

    public String getMailTransportProtocol() {
        return this.transportProtocol;
    }

    public String getMailStoreProtocolClass() {
        return this.storeProtocolClass;
    }

    public String getMailTransportProtocolClass() {
        return this.transportProtocolClass;
    }

    public boolean getMailDebug() {
        return this.debug;
    }

    public String getDescription() {
        return this.description;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public Properties getMailProperties() {
        return this.mailProperties;
    }

    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("MailConfiguration: [");
        toStringBuffer.append("description=").append(this.description);
        toStringBuffer.append(", jndiName=").append(this.jndiName);
        toStringBuffer.append(", enabled=").append(this.enabled);
        toStringBuffer.append(", storeProtocol=").append(this.storeProtocol);
        toStringBuffer.append(", transportProtocol=").append(this.transportProtocol);
        toStringBuffer.append(", storeProtocolClass=").append(this.storeProtocolClass);
        toStringBuffer.append(", transportProtocolClass=").append(this.transportProtocolClass);
        toStringBuffer.append(", mailHost=").append(this.mailHost);
        toStringBuffer.append(", username=").append(this.username);
        toStringBuffer.append(", mailFrom=").append(this.mailFrom);
        toStringBuffer.append(", debug=").append(this.debug);
        toStringBuffer.append(", mailProperties: [");
        Enumeration<?> e = this.mailProperties.propertyNames();
        boolean isFirst = true;
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.mailProperties.getProperty(name);
            if (!isFirst) {
                toStringBuffer.append(", ");
            }
            toStringBuffer.append(name).append("=").append(value);
            isFirst = false;
        }
        toStringBuffer.append("]]");
    }
}

