/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.callback;

import com.sun.xml.wss.RealmAuthenticationAdapter;
import com.sun.xml.wss.impl.callback.ValidatorExtension;
import com.sun.xml.wss.impl.callback.XWSSCallback;
import com.sun.xml.wss.impl.misc.Base64;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import javax.security.auth.callback.Callback;
import org.apache.xml.security.exceptions.Base64DecodingException;

public class PasswordValidationCallback
extends XWSSCallback
implements Callback {
    private Request request;
    private boolean result = false;
    private PasswordValidator validator;
    private RealmAuthenticationAdapter authenticator = null;

    public PasswordValidationCallback(Request request) {
        this.request = request;
    }

    public boolean getResult() {
        try {
            if (this.validator != null) {
                this.result = this.validator.validate(this.request);
            }
        }
        catch (ClassCastException e) {
            throw e;
        }
        catch (Exception e) {
            return false;
        }
        return this.result;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setValidator(PasswordValidator validator) {
        this.validator = validator;
        if (this.validator instanceof ValidatorExtension) {
            ((ValidatorExtension)((Object)this.validator)).setRuntimeProperties(this.getRuntimeProperties());
        }
    }

    public PasswordValidator getValidator() {
        return this.validator;
    }

    public void setRealmAuthentcationAdapter(RealmAuthenticationAdapter adapter) {
        this.authenticator = adapter;
    }

    public RealmAuthenticationAdapter getRealmAuthenticationAdapter() {
        return this.authenticator;
    }

    public static interface Request {
    }

    public static interface PasswordValidator {
        public boolean validate(Request var1) throws PasswordValidationException;
    }

    public static class PasswordValidationException
    extends Exception {
        private static final long serialVersionUID = 431043579458710413L;

        public PasswordValidationException(String message) {
            super(message);
        }

        public PasswordValidationException(String message, Throwable cause) {
            super(message, cause);
        }

        public PasswordValidationException(Throwable cause) {
            super(cause);
        }
    }

    public static abstract class DerivedKeyPasswordValidator
    implements PasswordValidator {
        protected DerivedKeyPasswordValidator() {
        }

        public abstract void setPassword(Request var1);
    }

    public static abstract class WsitDigestPasswordValidator
    extends DigestPasswordValidator {
        protected WsitDigestPasswordValidator() {
        }

        public abstract void setPassword(Request var1);
    }

    public static class DigestPasswordValidator
    implements PasswordValidator {
        @Override
        public boolean validate(Request request) throws PasswordValidationException {
            byte[] hash;
            byte[] bytesToHash;
            DigestPasswordRequest req = (DigestPasswordRequest)request;
            String passwd = req.getPassword();
            String nonce = req.getNonce();
            String created = req.getCreated();
            String passwordDigest = req.getDigest();
            if (null == passwd) {
                return false;
            }
            byte[] decodedNonce = null;
            if (null != nonce) {
                try {
                    decodedNonce = Base64.decode(nonce);
                }
                catch (Base64DecodingException bde) {
                    throw new PasswordValidationException(bde);
                }
            }
            Object utf8String = "";
            if (created != null) {
                utf8String = (String)utf8String + created;
            }
            utf8String = (String)utf8String + passwd;
            byte[] utf8Bytes = ((String)utf8String).getBytes(StandardCharsets.UTF_8);
            if (decodedNonce != null) {
                bytesToHash = new byte[utf8Bytes.length + decodedNonce.length];
                System.arraycopy(decodedNonce, 0, bytesToHash, 0, decodedNonce.length);
                System.arraycopy(utf8Bytes, 0, bytesToHash, decodedNonce.length, utf8Bytes.length);
            } else {
                bytesToHash = utf8Bytes;
            }
            try {
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                hash = sha.digest(bytesToHash);
            }
            catch (Exception e) {
                throw new PasswordValidationException("Password Digest could not be created" + String.valueOf(e));
            }
            return passwordDigest.equals(Base64.encode(hash));
        }
    }

    public static class DerivedKeyPasswordRequest
    implements Request {
        private String userName;
        private String password;
        private String created;

        public DerivedKeyPasswordRequest(String userName) {
            this.userName = userName;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUsername() {
            return this.userName;
        }

        public void setUsername(String name) {
            this.userName = name;
        }

        public String getCreated() {
            return this.created;
        }
    }

    public static class DigestPasswordRequest
    implements Request {
        private String password;
        private String userName;
        private String digest;
        private String nonce;
        private String created;

        public DigestPasswordRequest(String userName, String digest, String nonce, String created) {
            this.userName = userName;
            this.digest = digest;
            this.nonce = nonce;
            this.created = created;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUsername() {
            return this.userName;
        }

        public String getDigest() {
            return this.digest;
        }

        public String getNonce() {
            return this.nonce;
        }

        public String getCreated() {
            return this.created;
        }
    }

    public static class PlainTextPasswordRequest
    implements Request {
        private String password;
        private String userName;

        public PlainTextPasswordRequest(String userName, String password) {
            this.password = password;
            this.userName = userName;
        }

        public String getUsername() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

