/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.history;

import java.io.StringWriter;
import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.Session;

public class HistoricalSession
extends AbstractSession {
    protected final AbstractSession parent;
    protected final AsOfClause asOfClause;

    public HistoricalSession(AbstractSession parent, AsOfClause clause) {
        this.asOfClause = clause;
        this.parent = parent;
        this.project = parent.getProject();
        this.queries = parent.getQueries();
        this.profiler = parent.getProfiler();
        this.isInProfile = parent.isInProfile();
        this.isLoggingOff = parent.isLoggingOff();
        this.sessionLog = parent.getSessionLog();
        if (parent.hasEventManager()) {
            this.eventManager = parent.getEventManager().clone(this);
        }
        this.exceptionHandler = parent.getExceptionHandler();
        this.descriptors = parent.getDescriptors();
    }

    @Override
    public Session acquireHistoricalSession(AsOfClause clause) throws ValidationException {
        throw ValidationException.cannotAcquireHistoricalSession();
    }

    @Override
    public UnitOfWorkImpl acquireUnitOfWork() {
        throw ValidationException.operationNotSupported(this.getClass().getSimpleName() + ".acquireUnitOfWork");
    }

    @Override
    public void beginTransaction() throws DatabaseException, ConcurrencyException {
        throw ValidationException.operationNotSupported(this.getClass().getSimpleName() + ".beginTransaction");
    }

    @Override
    public void commitTransaction() throws DatabaseException, ConcurrencyException {
        throw ValidationException.operationNotSupported(this.getClass().getSimpleName() + ".commitTransaction");
    }

    @Override
    public AbstractSession getExecutionSession(DatabaseQuery query) {
        return this.getParent().getExecutionSession(query);
    }

    @Override
    public AsOfClause getAsOfClause() {
        return this.asOfClause;
    }

    public Object getAsOfValue() {
        return this.getAsOfClause().getValue();
    }

    @Override
    public AbstractSession getParent() {
        return this.parent;
    }

    @Override
    public ServerPlatform getServerPlatform() {
        return this.getParent().getServerPlatform();
    }

    public boolean hasAsOfClause() {
        return this.asOfClause != null && this.asOfClause.getValue() != null;
    }

    @Override
    public Object internalExecuteQuery(DatabaseQuery query, AbstractRecord databaseRow) throws DatabaseException {
        if (!query.isReadQuery()) {
            throw QueryException.invalidQueryOnHistoricalSession(query);
        }
        return super.internalExecuteQuery(query, databaseRow);
    }

    @Override
    public boolean isInTransaction() {
        return false;
    }

    @Override
    public boolean isHistoricalSession() {
        return true;
    }

    @Override
    public DatabaseQuery prepareDatabaseQuery(DatabaseQuery query) {
        DatabaseQuery clonedQuery = (DatabaseQuery)query.clone();
        clonedQuery.setIsExecutionClone(true);
        clonedQuery.setIsPrepared(false);
        return clonedQuery;
    }

    @Override
    public void rollbackTransaction() throws DatabaseException, ConcurrencyException {
        throw ValidationException.operationNotSupported(this.getClass().getSimpleName() + ".rollbackTransaction");
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(this.getSessionTypeString());
        writer.write("(");
        writer.write(this.getAsOfClause().toString());
        writer.write(")");
        return writer.toString();
    }
}

