/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.api.container.Sniffer;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.EngineInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ContainerRegistry {
    @Inject
    ServiceLocator serviceLocator;
    Map<String, EngineInfo<?, ?>> containers = new HashMap();

    public synchronized void addContainer(String name, EngineInfo<?, ?> info) {
        this.containers.put(name, info);
        info.setRegistry(this);
    }

    public List<Sniffer> getStartedContainersSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        for (EngineInfo<?, ?> info : this.getContainers()) {
            sniffers.add(info.getSniffer());
        }
        return sniffers;
    }

    public synchronized EngineInfo<?, ?> getContainer(String name) {
        return this.containers.get(name);
    }

    public synchronized EngineInfo<?, ?> removeContainer(EngineInfo<?, ?> container) {
        for (Map.Entry<String, EngineInfo<?, ?>> entry : this.containers.entrySet()) {
            if (!entry.getValue().equals(container)) continue;
            return this.containers.remove(entry.getKey());
        }
        return null;
    }

    public Iterable<EngineInfo<?, ?>> getContainers() {
        return new ArrayList(this.containers.values());
    }
}

