/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings.Destructive;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings.Rocket;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings.SuperDestructionInterceptor;
import org.jboss.cdi.tck.util.ActionSequence;
import org.testng.Assert;

@Destructive
@Interceptor
@Priority(value=2200)
public class DestructionInterceptor
extends SuperDestructionInterceptor
implements Serializable {
    @PreDestroy
    public void preDestroy(InvocationContext ctx) {
        ActionSequence.addAction("preDestroy", DestructionInterceptor.class.getSimpleName());
        try {
            ctx.proceed();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @PostConstruct
    public void postConstruct(InvocationContext ctx) {
        Rocket target = (Rocket)ctx.getTarget();
        Assert.assertNotNull((Object)target.getFoo());
        ActionSequence.addAction("postConstruct", DestructionInterceptor.class.getSimpleName());
        try {
            ctx.proceed();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @AroundConstruct
    public void aroundConstruct(InvocationContext ctx) {
        ActionSequence.addAction("aroundConstruct", DestructionInterceptor.class.getSimpleName());
        try {
            ctx.proceed();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

