/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.session.async;

import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import java.io.IOException;
import org.jboss.cdi.tck.tests.context.session.async.SimpleSessionBean;
import org.jboss.cdi.tck.tests.context.session.async.StatusBean;
import org.jboss.cdi.tck.util.SimpleLogger;

public class SimpleAsyncListener
implements AsyncListener {
    public static boolean isSessionContextActive = false;
    private static final SimpleLogger logger = new SimpleLogger(SimpleAsyncListener.class);
    @Inject
    SimpleSessionBean simpleSessionBean;
    @Inject
    BeanManager beanManager;
    @Inject
    StatusBean statusBean;

    public void onComplete(AsyncEvent event) throws IOException {
        logger.log("onComplete", new Object[0]);
        if (!this.statusBean.isOnTimeout() && !this.statusBean.isOnError()) {
            this.statusBean.setOnComplete(this.checkSessionContextAvailability());
        }
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        logger.log("onTimeout", new Object[0]);
        this.statusBean.setOnTimeout(this.checkSessionContextAvailability());
        event.getAsyncContext().complete();
    }

    public void onError(AsyncEvent event) throws IOException {
        logger.log("onError", new Object[0]);
        this.statusBean.setOnError(this.checkSessionContextAvailability());
        event.getAsyncContext().complete();
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
        logger.log("onStartAsync", new Object[0]);
        this.statusBean.setOnStartAsync(this.checkSessionContextAvailability());
    }

    private boolean checkSessionContextAvailability() throws IOException {
        try {
            this.statusBean.setSessionBeanId(this.simpleSessionBean.getId());
            isSessionContextActive = this.beanManager.getContext(SessionScoped.class).isActive();
        }
        catch (Throwable e) {
            logger.log("Problem while checking request scope: " + e.getMessage(), new Object[0]);
        }
        return isSessionContextActive && this.statusBean.getSessionBeanId() != null;
    }
}

