/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.decorators.context.dependent;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.decorators.context.dependent.Interior;
import org.jboss.cdi.tck.tests.full.decorators.context.dependent.InteriorDecorator;
import org.jboss.cdi.tck.tests.full.decorators.context.dependent.RoomBinding;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class DependentContextTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DependentContextTest.class)).withBeansXml("beans.xml")).build();
    }

    @Test(groups={"cdi-full"})
    @SpecAssertion(section="dependent_objects", id="ab")
    public void testDependentScopedDecoratorsAreDependentObjectsOfBean() {
        Bean<Interior> roomBean = this.getBeans(Interior.class, new RoomBinding()).iterator().next();
        CreationalContext roomCreationalContext = this.getCurrentManager().createCreationalContext(roomBean);
        Interior room = (Interior)this.getCurrentManager().getReference(roomBean, Interior.class, roomCreationalContext);
        InteriorDecorator.reset();
        room.foo();
        assert (InteriorDecorator.getInstances().size() == 1);
        roomCreationalContext.release();
        assert (InteriorDecorator.isDestroyed());
    }
}

