/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.se.context.request;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.se.api.ClassPath;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.cdi.tck.tests.se.context.request.Payload;
import org.jboss.cdi.tck.tests.se.context.request.TestBean;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"se"})
@SpecVersion(spec="cdi", version="2.0")
public class RequestContextTest
extends Arquillian {
    @Deployment
    public static Archive<?> deployment() throws IOException {
        JavaArchive bda1 = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackage(RequestContextTest.class.getPackage())).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return ClassPath.builder().add(bda1).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="request_context", id="db"), @SpecAssertion(section="request_context", id="eb")})
    public void requestContextIsActiveDuringPostConstructCallback() {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer container = seContainerInitializer.initialize();){
            TestBean testBean = (TestBean)container.select(TestBean.class, new Annotation[0]).get();
            Assert.assertTrue((boolean)testBean.isReqContextActiveDuringPostConstruct());
            try {
                testBean.fail();
                Assert.fail();
            }
            catch (ContextNotActiveException contextNotActiveException) {
                // empty catch block
            }
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="request_context", id="da"), @SpecAssertion(section="request_context", id="ea")})
    public void requestContextIsActiveDuringAsyncObserverNotification() throws InterruptedException {
        SeContainerInitializer seContainerInitializer = SeContainerInitializer.newInstance();
        try (SeContainer container = seContainerInitializer.initialize();){
            Event event = container.getBeanManager().getEvent();
            LinkedBlockingQueue queue = new LinkedBlockingQueue();
            event.select(Payload.class, new Annotation[0]).fireAsync((Object)new Payload()).thenAccept(queue::offer);
            Payload payload = (Payload)queue.poll(2L, TimeUnit.SECONDS);
            event.select(Payload.class, new Annotation[0]).fireAsync((Object)payload).thenAccept(queue::offer);
            payload = (Payload)queue.poll(2L, TimeUnit.SECONDS);
            Assert.assertEquals((int)payload.getI(), (int)2);
        }
    }
}

