/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation;

import jakarta.enterprise.context.Conversation;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import org.jboss.cdi.tck.tests.context.conversation.Cloud;
import org.jboss.cdi.tck.tests.context.conversation.ConversationContextObserver;
import org.jboss.cdi.tck.util.BeanLookupUtils;

public class ConversationStatusServlet
extends HttpServlet {
    private static final long serialVersionUID = 2984756941080790899L;
    @Inject
    private BeanManager beanManager;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getParameter("method");
        if ("cid".equals(method)) {
            Conversation conversation = (Conversation)BeanLookupUtils.getContextualReference((BeanManager)this.beanManager, Conversation.class, (Annotation[])new Annotation[0]);
            this.serializeToResponse(conversation.getId(), resp);
        } else if ("cloudDestroyed".equals(method)) {
            if (Cloud.isDestroyed()) {
                resp.setStatus(200);
            } else {
                resp.setStatus(208);
            }
        } else if ("conversationContextDestroyed".equals(method)) {
            if (ConversationContextObserver.isDestroyed()) {
                resp.setStatus(200);
            } else {
                resp.setStatus(208);
            }
        } else if ("invalidateSession".equals(method)) {
            req.getSession().invalidate();
        } else if ("resetCloud".equals(method)) {
            Cloud.setDestroyed(false);
        } else if ("resetConversationContextObserver".equals(method)) {
            ConversationContextObserver.reset();
        } else {
            resp.sendError(500);
        }
    }

    private void serializeToResponse(Object object, HttpServletResponse resp) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)resp.getOutputStream());
        oos.writeObject(object);
        oos.flush();
        oos.close();
    }
}

