/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings.ejb;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings.ejb.AirborneInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings.ejb.DestructionInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings.ejb.Missile;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings.ejb.Rocket;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings.ejb.SuperDestructionInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.lifecycleCallback.bindings.ejb.Weapon;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.BeansXml;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="interceptors", version="1.2")
public class SessionBeanLifecycleInterceptorDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SessionBeanLifecycleInterceptorDefinitionTest.class)).withBeansXml(new BeansXml().interceptors(new Class[]{AirborneInterceptor.class, DestructionInterceptor.class}))).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="b"), @SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="c")})
    public void testLifecycleInterception() {
        ActionSequence.reset();
        Bean bean = this.getUniqueBean(Missile.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext((Contextual)bean);
        Missile missile = (Missile)bean.create(ctx);
        missile.fire();
        bean.destroy((Object)missile, ctx);
        Assert.assertEquals((int)ActionSequence.getSequenceSize((String)"postConstruct"), (int)1);
        Assert.assertEquals((String)((String)ActionSequence.getSequenceData((String)"postConstruct").get(0)), (String)AirborneInterceptor.class.getSimpleName());
        Assert.assertEquals((int)ActionSequence.getSequenceSize((String)"preDestroy"), (int)1);
        Assert.assertEquals((String)((String)ActionSequence.getSequenceData((String)"preDestroy").get(0)), (String)AirborneInterceptor.class.getSimpleName());
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="ea"), @SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="eb"), @SpecAssertion(section="int_methods_for_lifecycle_event_callbacks", id="i"), @SpecAssertion(section="int_ordering_rules", id="i")})
    public void testMultipleLifecycleInterceptors() {
        ActionSequence.reset();
        Bean bean = this.getUniqueBean(Rocket.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext((Contextual)bean);
        Rocket rocket = (Rocket)bean.create(ctx);
        rocket.fire();
        bean.destroy((Object)rocket, ctx);
        ActionSequence postConstruct = ActionSequence.getSequence((String)"postConstruct");
        postConstruct.assertDataEquals(new Class[]{AirborneInterceptor.class, SuperDestructionInterceptor.class, DestructionInterceptor.class, Weapon.class, Rocket.class});
        ActionSequence preDestroy = ActionSequence.getSequence((String)"preDestroy");
        preDestroy.assertDataEquals(new Class[]{AirborneInterceptor.class, SuperDestructionInterceptor.class, DestructionInterceptor.class, Weapon.class, Rocket.class});
        ActionSequence aroundConstruct = ActionSequence.getSequence((String)"aroundConstruct");
        aroundConstruct.assertDataEquals(new Class[]{AirborneInterceptor.class, SuperDestructionInterceptor.class, DestructionInterceptor.class});
    }
}

