/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.diffmerge.internal.context;

import java.util.Iterator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;

public final class CompareControls {
    private CompareControls() {
    }

    public static boolean areEqual(VControl left, VControl right) {
        return CompareControls.areEqual(left.getDomainModelReference(), right.getDomainModelReference());
    }

    public static boolean areEqual(VDomainModelReference left, VDomainModelReference right) {
        Iterator leftSettings = left.getIterator();
        Iterator rightSettings = right.getIterator();
        boolean leftHasNext = leftSettings.hasNext();
        boolean rightHasNext = rightSettings.hasNext();
        while (leftHasNext && rightHasNext) {
            EStructuralFeature.Setting leftSetting = (EStructuralFeature.Setting)leftSettings.next();
            EStructuralFeature.Setting rightSetting = (EStructuralFeature.Setting)rightSettings.next();
            Object leftValue = leftSetting.get(true);
            Object rightValue = rightSetting.get(true);
            leftHasNext = leftSettings.hasNext();
            rightHasNext = rightSettings.hasNext();
            if (leftValue == null && rightValue == null || EcorePackage.eINSTANCE.getEReference().isInstance((Object)leftSetting.getEStructuralFeature()) || EcorePackage.eINSTANCE.getEReference().isInstance((Object)rightSetting.getEStructuralFeature())) continue;
            if (leftValue == null && rightValue != null) {
                return false;
            }
            if (leftValue != null && rightValue == null) {
                return false;
            }
            if (leftValue.equals(rightValue)) continue;
            return false;
        }
        return !leftHasNext && !rightHasNext;
    }
}

