/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.helpgenerator.documentation;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ease.helpgenerator.documentation.IClassNameResolver;
import org.eclipse.ease.helpgenerator.documentation.linkcreators.ContainmentLinkCreator;
import org.eclipse.ease.helpgenerator.documentation.linkcreators.StaticTextLinkCreator;

public class ReferenceReplacer
extends ContainmentLinkCreator
implements IClassNameResolver {
    private static final Pattern REFERENCE = Pattern.compile("\\{@(?:link|module)\\s+.*?\\}");
    private IClassNameResolver fClassNameResolver;

    public ReferenceReplacer() {
        this.setClassNameResolver(className -> className);
    }

    public String replaceReferences(String content) {
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = REFERENCE.matcher(content);
        while (matcher.find()) {
            matcher.appendReplacement(buffer, this.getReplacement(matcher));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private String getReplacement(Matcher matcher) {
        try {
            return this.createLink(matcher.group());
        }
        catch (IOException e) {
            return new StaticTextLinkCreator().createLink(matcher.group());
        }
    }

    public final void setClassNameResolver(IClassNameResolver classNameResolver) {
        this.fClassNameResolver = classNameResolver;
    }

    @Override
    public String resolveClassName(String className) {
        return this.fClassNameResolver.resolveClassName(className);
    }
}

