/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.handlers;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.websocket.Session;
import org.eclipse.dirigible.runtime.chrome.debugger.DebugConfiguration;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.DebuggerPausedRequest;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.ErrorResponse;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.MessageRequest;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.MessageResponse;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.ResultResponse;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.MessageHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.models.Breakpoint;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.BreakpointRepository;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.MessageDispatcher;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.ScriptRepository;

public class GetScriptSourceHandler
implements MessageHandler {
    private static final Gson GSON = new Gson();

    @Override
    public void handle(String message, Session session) throws IOException {
        MessageResponse response;
        MessageRequest request = (MessageRequest)GSON.fromJson(message, MessageRequest.class);
        Integer id = request.getId();
        Map<String, Object> params = request.getParams();
        String scriptId = (String)params.get("scriptId");
        ScriptRepository repository = ScriptRepository.getInstance();
        String scriptSource = repository.getSourceFor(scriptId);
        if (scriptSource == null) {
            response = new ErrorResponse(id, String.format("No script for id: %s", scriptId));
        } else {
            if (this.navigatedDebuggableScript()) {
                this.sendDebugNotifications(scriptId, session);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("scriptSource", scriptSource);
            response = new ResultResponse(id, result);
        }
        MessageDispatcher.sendMessage(GSON.toJson((Object)response), session);
    }

    private boolean navigatedDebuggableScript() {
        return MessageDispatcher.sentMessageContain("Page.frameStartedLoading");
    }

    private void sendDebugNotifications(String scriptId, Session session) {
        BreakpointRepository breakpointRepo = BreakpointRepository.getInstance();
        String userId = session.getUserPrincipal().getName();
        Set<Breakpoint> sortedBreakpoints = breakpointRepo.getSortedBreakpointsForScript(userId, scriptId);
        Breakpoint firstBreakpoint = sortedBreakpoints.toArray(new Breakpoint[sortedBreakpoints.size()])[0];
        Integer breakpointLine = firstBreakpoint.getLocation().getLineNumber().intValue();
        for (Breakpoint b : sortedBreakpoints) {
            this.sendBreakpointResolved(b, session);
        }
        DebuggerPausedRequest.sendRequest(scriptId, session, breakpointLine);
    }

    private void sendBreakpointResolved(Breakpoint breakpoint, Session session) {
        MessageRequest request = new MessageRequest();
        request.setId(null);
        request.setMethod("Debugger.breakpointResolved");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("breakpointId", breakpoint.getId());
        String userId = session.getUserPrincipal().getName();
        DebugConfiguration.setCurrentExecutionLocation(userId, breakpoint.getLocation());
        params.put("location", DebugConfiguration.getCurrentExecutionLocation(userId));
        MessageDispatcher.sendMessage(GSON.toJson((Object)request), session);
    }
}

