/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.wizard.folder;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dirigible.ide.workspace.ui.shared.FocusableWizardPage;
import org.eclipse.dirigible.ide.workspace.ui.shared.IValidationStatus;
import org.eclipse.dirigible.ide.workspace.ui.viewer.WorkspaceViewer;
import org.eclipse.dirigible.ide.workspace.ui.wizard.folder.Messages;
import org.eclipse.dirigible.ide.workspace.ui.wizard.folder.NewFolderWizardModel;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewFolderWizardMainPage
extends FocusableWizardPage {
    private static final long serialVersionUID = 2122979040935623152L;
    private static final String FOLDER_NAME = Messages.NewFolderWizardMainPage_FOLDER_NAME;
    private static final String PARENT_LOCATION = Messages.NewFolderWizardMainPage_PARENT_LOCATION;
    private static final String PAGE_NAME = "Main Page";
    private static final String PAGE_TITLE = Messages.NewFolderWizardMainPage_PAGE_TITLE;
    private static final String PAGE_DESCRIPTION = Messages.NewFolderWizardMainPage_PAGE_DESCRIPTION;
    private Text folderNameField = null;
    private Text parentLocationField = null;
    private WorkspaceViewer workspaceViewer = null;
    private NewFolderWizardModel model;

    public NewFolderWizardMainPage(NewFolderWizardModel model) {
        super(PAGE_NAME);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
        this.model = model;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        Label parentLocationLabel = new Label(composite, 0);
        parentLocationLabel.setText(PARENT_LOCATION);
        parentLocationLabel.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.parentLocationField = new Text(composite, 2048);
        this.parentLocationField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.parentLocationField.addModifyListener(new ModifyListener(){
            private static final long serialVersionUID = -7855934332806569553L;

            public void modifyText(ModifyEvent event) {
                NewFolderWizardMainPage.this.onParentLocationChanged(NewFolderWizardMainPage.this.parentLocationField.getText());
            }
        });
        this.workspaceViewer = new WorkspaceViewer(composite, 2052);
        this.workspaceViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.workspaceViewer.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewFolderWizardMainPage.this.onWorkspaceViewerSelection((IStructuredSelection)event.getSelection());
            }
        });
        Label folderNameLabel = new Label(composite, 0);
        folderNameLabel.setText(FOLDER_NAME);
        folderNameLabel.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.folderNameField = new Text(composite, 2048);
        this.folderNameField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.folderNameField.addModifyListener(new ModifyListener(){
            private static final long serialVersionUID = 6720113124205697812L;

            public void modifyText(ModifyEvent event) {
                NewFolderWizardMainPage.this.onFolderNameChanged(NewFolderWizardMainPage.this.folderNameField.getText());
            }
        });
        this.setFocusable((Control)this.folderNameField);
        this.initialize();
    }

    private void onWorkspaceViewerSelection(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof IContainer) {
            this.onWorkspaceContainerSelected((IContainer)element);
        }
    }

    public void setFolderName(String name) {
        if (this.folderNameField == null || this.folderNameField.isDisposed()) {
            return;
        }
        if (!NewFolderWizardMainPage.areEqual(this.folderNameField.getText(), name)) {
            this.folderNameField.setText(name);
        }
    }

    public void setParentLocation(String location) {
        if (this.parentLocationField == null || this.parentLocationField.isDisposed()) {
            return;
        }
        if (!NewFolderWizardMainPage.areEqual(this.parentLocationField.getText(), location)) {
            this.parentLocationField.setText(location);
        }
    }

    private static boolean areEqual(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null) {
            return a.equals(b);
        }
        return b.equals(a);
    }

    public void setWarningMessage(String message) {
        this.setMessage(message, 2);
    }

    public void setCanFinish(boolean value) {
        this.setPageComplete(value);
    }

    public void initialize() {
        this.setFolderName(this.model.getFolderName());
        this.setParentLocation(this.model.getParentLocation());
        this.revalidateModel();
    }

    public void onFolderNameChanged(String folderName) {
        this.model.setFolderName(folderName);
        this.revalidateModel();
    }

    public void onParentLocationChanged(String parentLocation) {
        this.model.setParentLocation(parentLocation);
        this.revalidateModel();
    }

    public void onWorkspaceContainerSelected(IContainer container) {
        IPath containerPath = container.getFullPath();
        this.model.setParentLocation(containerPath.toString());
        this.setParentLocation(containerPath.toString());
        this.revalidateModel();
    }

    private void revalidateModel() {
        IValidationStatus status = this.model.validate();
        if (status.hasErrors()) {
            this.setErrorMessage(status.getMessage());
            this.setWarningMessage(null);
            this.setCanFinish(false);
        } else if (status.hasWarnings()) {
            this.setErrorMessage(null);
            this.setWarningMessage(status.getMessage());
            this.setCanFinish(true);
        } else {
            this.setErrorMessage(null);
            this.setWarningMessage(null);
            this.setCanFinish(true);
        }
    }
}

