/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.db.dao;

import java.util.Arrays;
import org.eclipse.dirigible.repository.db.DBBaseException;
import org.eclipse.dirigible.repository.db.DBRepository;
import org.eclipse.dirigible.repository.db.dao.DBObject;

public class DBFile
extends DBObject {
    private boolean binary = false;
    private String contentType;

    public DBFile(DBRepository repository, boolean isBinary, String contentType) {
        super(repository);
        this.binary = isBinary;
        this.contentType = contentType;
    }

    public void delete() throws DBBaseException {
        this.getRepository().getRepositoryDAO().removeFileByPath(this.getPath());
    }

    public void rename(String newPath) throws DBBaseException {
        this.getRepository().getRepositoryDAO().renameFile(this.getPath(), newPath);
    }

    public byte[] getData() throws DBBaseException {
        if (this.isBinary()) {
            byte[] data = this.getRepository().getRepositoryDAO().getBinary(this);
            return data;
        }
        byte[] data = this.getRepository().getRepositoryDAO().getDocument(this);
        return data;
    }

    public void setData(byte[] content) throws DBBaseException {
        byte[] old = this.getData();
        if (old != null && Arrays.equals(old, content)) {
            return;
        }
        if (this.isBinary()) {
            this.getRepository().getRepositoryDAO().setBinary(this, content, this.getContentType());
        } else {
            this.getRepository().getRepositoryDAO().setDocument(this, content);
        }
    }

    public boolean isBinary() {
        return this.binary;
    }

    public String getContentType() {
        return this.contentType;
    }
}

