/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.dirigible.ide.editor.text.editor.TextEditor;
import org.eclipse.dirigible.ide.workspace.ui.commands.Messages;
import org.eclipse.dirigible.ide.workspace.ui.wizards.rename.RenameWizard;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameCommandHandler
extends AbstractHandler {
    private static final String RENAME_OPERATION_CANCELLED_CAN_ONLY_RENAME_INSTANCES_OF_I_RESOURCE = Messages.RenameCommandHandler_RENAME_OPERATION_CANCELLED_CAN_ONLY_RENAME_INSTANCES_OF_I_RESOURCE;
    private static final String RENAME_OPERATION_CANCELLED_CAN_ONLY_RENAME_A_SINGLE_RESOURCE_AT_A_TIME = Messages.RenameCommandHandler_RENAME_OPERATION_CANCELLED_CAN_ONLY_RENAME_A_SINGLE_RESOURCE_AT_A_TIME;
    private static final Logger log = Logger.getLogger(RenameCommandHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            this.renameSelection((IStructuredSelection)selection);
        }
        return null;
    }

    private void renameFileInEditor(String oldFileName, String newFileName) {
        IEditorReference[] editors;
        IEditorReference[] iEditorReferenceArray = editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorRef = iEditorReferenceArray[n2];
            IEditorPart editorPart = editorRef.getEditor(false);
            if (editorPart != null && editorPart.getTitle().equals(oldFileName) && editorPart instanceof TextEditor) {
                ((TextEditor)editorPart).setPartName(newFileName);
                return;
            }
            ++n2;
        }
    }

    private void renameSelection(IStructuredSelection selection) {
        if (selection.size() != 1) {
            log.warn(RENAME_OPERATION_CANCELLED_CAN_ONLY_RENAME_A_SINGLE_RESOURCE_AT_A_TIME);
            return;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof IResource)) {
            log.warn(RENAME_OPERATION_CANCELLED_CAN_ONLY_RENAME_INSTANCES_OF_I_RESOURCE);
            return;
        }
        String newValue = this.renameResource((IResource)element);
        if (newValue != null) {
            this.renameFileInEditor(((IResource)element).getName(), newValue);
        }
    }

    private String renameResource(IResource resource) {
        RenameWizard wizard = new RenameWizard(resource);
        WizardDialog dialog = new WizardDialog(null, (IWizard)wizard);
        if (dialog.open() == 1) {
            return null;
        }
        return wizard.getText();
    }
}

