/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.publish;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.common.ExtensionPointUtils;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.Messages;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.ide.publish.PublishManagerException;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class PublishManager {
    private static final Logger logger = Logger.getLogger(PublishManager.class);
    private static final String PUBLISH_ERROR = Messages.getString("PublishManager.PUBLISH_ERROR");
    private static final String THE_USER_S_DOES_NOT_HAVE_OPERATOR_ROLE_TO_PERFORM_PUBLISH_OPERATION = Messages.getString("PublishManager.THE_USER_S_DOES_NOT_HAVE_OPERATOR_ROLE_TO_PERFORM_PUBLISH_OPERATION");
    private static final String PUBLISHER_EXTENSION_HAS_AN_INVALID_IMPLEMENTING_CLASS_CONFIGURED = Messages.getString("PublishManager.PUBLISHER_EXTENSION_HAS_AN_INVALID_IMPLEMENTING_CLASS_CONFIGURED");
    private static final String COULD_NOT_CREATE_PUBLISHER_INSTANCE = Messages.getString("PublishManager.COULD_NOT_CREATE_PUBLISHER_INSTANCE");
    private static final String EXTENSION_POINT_0_COULD_NOT_BE_FOUND = Messages.getString("PublishManager.EXTENSION_POINT_0_COULD_NOT_BE_FOUND");
    private static final String PUBLISHER_EXTENSION_POINT_ID = "org.eclipse.dirigible.ide.publish.publisher";
    private static final String PUBLISHER_ELEMENT_NAME = "publisher";
    private static final String PUBLISHER_CLASS_ATTRIBUTE = "class";
    private static final String UNKNOWN_SELECTION_TYPE = "Unknown Selection Type";
    static List<IPublisher> publishers = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IPublisher> getPublishers() {
        Class<PublishManager> clazz = PublishManager.class;
        synchronized (PublishManager.class) {
            if (publishers == null) {
                publishers = new ArrayList<IPublisher>();
                IExtensionPoint extensionPoint = ExtensionPointUtils.getExtensionPoint((String)PUBLISHER_EXTENSION_POINT_ID);
                if (extensionPoint == null) {
                    throw new PublishManagerException(MessageFormat.format(EXTENSION_POINT_0_COULD_NOT_BE_FOUND, PUBLISHER_EXTENSION_POINT_ID));
                }
                IConfigurationElement[] publisherElements = PublishManager.getPublisherElements(extensionPoint.getExtensions());
                String publisherName = null;
                try {
                    IConfigurationElement[] iConfigurationElementArray = publisherElements;
                    int n = publisherElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement publisherElement = iConfigurationElementArray[n2];
                        publisherName = publisherElement.getAttribute(PUBLISHER_CLASS_ATTRIBUTE);
                        publishers.add(PublishManager.createPublisher(publisherElement));
                        ++n2;
                    }
                }
                catch (CoreException ex) {
                    throw new PublishManagerException(String.format(COULD_NOT_CREATE_PUBLISHER_INSTANCE, publisherName), ex);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return publishers;
        }
    }

    public static IProject[] getProjects(ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            logger.error(UNKNOWN_SELECTION_TYPE);
            return new IProject[0];
        }
        HashSet<IProject> result = new HashSet<IProject>();
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        IProject project = null;
        Object[] objectArray = structuredSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            project = PublishManager.getProject(element);
            if (project != null) {
                result.add(project);
            }
            ++n2;
        }
        return result.toArray(new IProject[0]);
    }

    public static IFile[] getFiles(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            logger.error(UNKNOWN_SELECTION_TYPE);
            return new IFile[0];
        }
        HashSet<IFile> result = new HashSet<IFile>();
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object[] objectArray = structuredSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IFile) {
                result.add((IFile)element);
            }
            ++n2;
        }
        return result.toArray(new IFile[0]);
    }

    private static IProject getProject(Object element) {
        IProject project = null;
        if (element instanceof IProject) {
            project = (IProject)element;
        } else if (element instanceof IFile) {
            project = ((IFile)element).getProject();
        } else if (element instanceof IFolder) {
            project = ((IFolder)element).getProject();
        }
        return project;
    }

    public static void activateProject(IProject project) throws PublishException {
        PublishManager.publish(project, false);
    }

    public static void publishProject(IProject project) throws PublishException {
        if (!CommonParameters.isUserInRole((String)"Operator")) {
            String message = String.format(THE_USER_S_DOES_NOT_HAVE_OPERATOR_ROLE_TO_PERFORM_PUBLISH_OPERATION, CommonParameters.getUserName());
            MessageDialog.openError(null, (String)PUBLISH_ERROR, (String)message);
            return;
        }
        PublishManager.publish(project, true);
    }

    private static void publish(IProject project, boolean publish) throws PublishException {
        List<IPublisher> publishers = PublishManager.getPublishers();
        Iterator<IPublisher> iterator = publishers.iterator();
        while (iterator.hasNext()) {
            IPublisher iPublisher;
            IPublisher publisher = iPublisher = iterator.next();
            if (publish) {
                publisher.publish(project);
                continue;
            }
            publisher.activate(project);
        }
    }

    private static IConfigurationElement[] getPublisherElements(IExtension[] extensions) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (PUBLISHER_ELEMENT_NAME.equals(element.getName())) {
                    result.add(element);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IConfigurationElement[0]);
    }

    private static IPublisher createPublisher(IConfigurationElement publisherElement) throws CoreException {
        Object publisher = publisherElement.createExecutableExtension(PUBLISHER_CLASS_ATTRIBUTE);
        if (!(publisher instanceof IPublisher)) {
            throw new PublishManagerException(PUBLISHER_EXTENSION_HAS_AN_INVALID_IMPLEMENTING_CLASS_CONFIGURED);
        }
        return (IPublisher)publisher;
    }

    private PublishManager() {
    }
}

