/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.mail;

import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.scripting.IMailService;

public class MailSender
implements IMailService {
    private static final Logger logger = Logger.getLogger((String)MailSender.class.getCanonicalName());

    @Override
    public String sendMail(String from, String to, String subject, String content) {
        try {
            Session smtpSession = (Session)System.getProperties().get("MailSession");
            Transport transport = smtpSession.getTransport();
            transport.connect();
            MimeMessage mimeMessage = MailSender.createMimeMessage(smtpSession, from, to, subject, content);
            transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
            transport.close();
        }
        catch (Exception e) {
            logger.error(String.valueOf(this.getClass().getCanonicalName()) + "#sendMail()", (Throwable)e);
            return e.getMessage();
        }
        return "";
    }

    private static MimeMessage createMimeMessage(Session smtpSession, String from, String to, String subjectText, String mailText) throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(smtpSession);
        InternetAddress[] fromAddress = InternetAddress.parse((String)from);
        InternetAddress[] toAddresses = InternetAddress.parse((String)to);
        mimeMessage.setFrom((Address)fromAddress[0]);
        mimeMessage.setRecipients(MimeMessage.RecipientType.TO, (Address[])toAddresses);
        mimeMessage.setSubject(subjectText, "UTF-8");
        MimeMultipart multiPart = new MimeMultipart("alternative");
        MimeBodyPart part = new MimeBodyPart();
        part.setText(mailText, "utf-8", "plain");
        multiPart.addBodyPart((BodyPart)part);
        mimeMessage.setContent((Multipart)multiPart);
        return mimeMessage;
    }
}

