/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures;

import org.eclipse.emf.diffmerge.structures.IEqualityBasedStructure;
import org.eclipse.emf.diffmerge.structures.IProperty;
import org.eclipse.emf.diffmerge.structures.IPropertyValue;
import org.eclipse.emf.diffmerge.structures.IStructureWithProperties;

public class PropertyValue<V>
implements IPropertyValue<V> {
    private static final PropertyValue<Object> UNKNOWN_VALUE = new PropertyValue();
    private static final PropertyValue<Boolean> FALSE_VALUE = new PropertyValue<Boolean>(Boolean.FALSE);
    private static final PropertyValue<Boolean> TRUE_VALUE = new PropertyValue<Boolean>(Boolean.TRUE);
    private final boolean _isUnknown;
    private final V _value;

    protected PropertyValue() {
        this._isUnknown = true;
        this._value = null;
    }

    public PropertyValue(V value_p) {
        this._isUnknown = false;
        this._value = value_p;
    }

    @Override
    public boolean cannotBe(V value_p) {
        return this.isKnown() && !this.is(value_p);
    }

    public boolean equals(Object obj_p) {
        boolean result;
        if (!(obj_p instanceof IPropertyValue)) {
            result = false;
        } else {
            IPropertyValue peer = (IPropertyValue)obj_p;
            if (this.isUnknown()) {
                result = peer.isUnknown();
            } else {
                V actualValue = this.getValue();
                Object peerValue = peer.getValue();
                result = actualValue == null ? peerValue == null : actualValue.equals(peerValue);
            }
        }
        return result;
    }

    @Override
    public V getValue() {
        return this._value;
    }

    public int hashCode() {
        return 13 + (this._value == null ? 0 : this._value.hashCode());
    }

    @Override
    public boolean is(V value_p) {
        boolean result = false;
        if (this.isKnown()) {
            V actualValue = this.getValue();
            result = actualValue == null ? value_p == null : actualValue.equals(value_p);
        }
        return result;
    }

    @Override
    public boolean isKnown() {
        return !this.isUnknown();
    }

    @Override
    public boolean isUnknown() {
        return this._isUnknown;
    }

    @Override
    public boolean mayBe(V value_p) {
        return this.isUnknown() || this.is(value_p);
    }

    public static IPropertyValue<Boolean> all(Iterable<? extends IEqualityBasedStructure> structures_p, IProperty<Boolean> property_p) {
        IPropertyValue<Boolean> result = PropertyValue.trueValue();
        for (IEqualityBasedStructure iEqualityBasedStructure : structures_p) {
            IPropertyValue<Boolean> partialResult = PropertyValue.unknownValue();
            if (iEqualityBasedStructure instanceof IStructureWithProperties) {
                partialResult = ((IStructureWithProperties)((Object)iEqualityBasedStructure)).getProperty(property_p);
            }
            if ((result = PropertyValue.and(result, partialResult)).is(Boolean.FALSE)) break;
        }
        return result;
    }

    public static IPropertyValue<Boolean> and(IPropertyValue<Boolean> p1_p, IPropertyValue<Boolean> p2_p) {
        IPropertyValue<Boolean> result = p1_p.isUnknown() || p2_p.isUnknown() ? PropertyValue.unknownValue() : (p1_p.getValue() != false && p2_p.getValue() != false ? PropertyValue.trueValue() : PropertyValue.falseValue());
        return result;
    }

    public static IPropertyValue<Boolean> falseValue() {
        return FALSE_VALUE;
    }

    public static IPropertyValue<Boolean> not(IPropertyValue<Boolean> p1_p) {
        IPropertyValue<Boolean> result = p1_p.isUnknown() ? PropertyValue.unknownValue() : (p1_p.is(Boolean.TRUE) ? PropertyValue.falseValue() : PropertyValue.trueValue());
        return result;
    }

    public static IPropertyValue<Boolean> or(IPropertyValue<Boolean> p1_p, IPropertyValue<Boolean> p2_p) {
        IPropertyValue<Boolean> result = p1_p.isUnknown() ? (p2_p.isUnknown() || p2_p.is(Boolean.TRUE) ? p2_p : p1_p) : (p2_p.isUnknown() ? (p1_p.is(Boolean.TRUE) ? p1_p : p2_p) : (p1_p.getValue() != false || p2_p.getValue() != false ? PropertyValue.trueValue() : PropertyValue.falseValue()));
        return result;
    }

    public static IPropertyValue<Boolean> trueValue() {
        return TRUE_VALUE;
    }

    public static <V> IPropertyValue<V> unknownValue() {
        return UNKNOWN_VALUE;
    }

    public static IPropertyValue<Boolean> valueOf(boolean value_p) {
        return value_p ? PropertyValue.trueValue() : PropertyValue.falseValue();
    }
}

