/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.operations;

import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.core.helpers.TraceHelper;
import org.eclipse.capra.ui.operations.OperationsHelper;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.swt.widgets.Shell;

public class UpdateTraceOperation
extends AbstractOperation {
    private static final String ERROR_DIALOG_TITLE = "Error updating trace link";
    private static final String EXCEPTION_MESSAGE_RUNTIME_EXCEPTION = "An exception occured during the update of the trace link.";
    private static final String EXCEPTION_MESSAGE_INTERRUPTED_EXCEPTION = "The transaction to update the trace link was interrupted.";
    private Connection connection;
    private String featureName;
    private Object postUpdateValue;
    private Object preUpdateValue;

    public UpdateTraceOperation(String label, Connection connection, Object feature, Object value) {
        super(label);
        this.connection = connection;
        if (!(feature instanceof String)) {
            throw new IllegalArgumentException("Feature must be a string!");
        }
        this.featureName = (String)feature;
        this.postUpdateValue = value;
        this.preUpdateValue = this.getValue(connection, this.featureName);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.executeTraceUpdate(info, this.postUpdateValue);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.executeTraceUpdate(info, this.preUpdateValue);
    }

    private IStatus executeTraceUpdate(IAdaptable info, Object value) {
        Shell shell = (Shell)info.getAdapter(Shell.class);
        IStatus executionStatus = null;
        try {
            this.updateTrace(this.connection, this.featureName, value);
            executionStatus = Status.OK_STATUS;
        }
        catch (IllegalStateException e) {
            executionStatus = new Status(4, "org.eclipse.capra.ui", e.getMessage(), (Throwable)e);
            OperationsHelper.createErrorMessage(shell, executionStatus, ERROR_DIALOG_TITLE, e.getMessage());
        }
        catch (InterruptedException e) {
            executionStatus = new Status(4, "org.eclipse.capra.ui", e.getMessage(), (Throwable)e);
            OperationsHelper.createErrorMessage(shell, executionStatus, ERROR_DIALOG_TITLE, EXCEPTION_MESSAGE_INTERRUPTED_EXCEPTION);
        }
        catch (RuntimeException e) {
            executionStatus = new Status(4, "org.eclipse.capra.ui", e.getMessage(), (Throwable)e);
            OperationsHelper.createErrorMessage(shell, executionStatus, ERROR_DIALOG_TITLE, EXCEPTION_MESSAGE_RUNTIME_EXCEPTION);
        }
        return executionStatus;
    }

    private Object getValue(Connection connection, String featureName) {
        EStructuralFeature structuralFeature = connection.getTlink().eClass().getEStructuralFeature(featureName);
        return connection.getTlink().eGet(structuralFeature);
    }

    private void updateTrace(Connection connection, String featureName, Object value) throws IllegalStateException, InterruptedException {
        IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
        EObject traceModel = persistenceAdapter.getTraceModel(resourceSet);
        TraceHelper traceHelper = new TraceHelper(traceModel);
        EObject artifactModel = persistenceAdapter.getArtifactWrappers(resourceSet);
        EObject metadataModel = persistenceAdapter.getMetadataContainer(resourceSet);
        traceHelper.updateTrace(connection, featureName, value);
        persistenceAdapter.saveModels(traceModel, artifactModel, metadataModel);
    }
}

