/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.operations;

import java.util.Arrays;
import org.eclipse.capra.ui.operations.OperationsHelper;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class UpdateMetadataPropertyOperation
extends AbstractOperation {
    private static final String ERROR_DIALOG_TITLE = "Error updating metadata";
    private static final String EXCEPTION_MESSAGE_RUNTIME_EXCEPTION = "An exception occured during the update of the metadata.";
    private IPropertySource metadataPropertySource;
    private Object featureId;
    private Object postUpdateValue;
    private Object preUpdateValue;

    public UpdateMetadataPropertyOperation(Object carrier, String label, String feature, Object value) {
        super(label);
        this.metadataPropertySource = (IPropertySource)Platform.getAdapterManager().getAdapter(carrier, IPropertySource.class);
        IPropertyDescriptor descriptor = this.getPropertyDescriptor(feature);
        if (descriptor != null) {
            this.featureId = descriptor.getId();
        }
        this.postUpdateValue = value;
        this.preUpdateValue = this.getCurrentFeatureValue();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.executeMetadataUpdate(info, this.postUpdateValue);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.executeMetadataUpdate(info, this.preUpdateValue);
    }

    private Object getCurrentFeatureValue() {
        if (this.featureId != null) {
            return this.metadataPropertySource.getPropertyValue(this.featureId);
        }
        return null;
    }

    private IPropertyDescriptor getPropertyDescriptor(String displayName) {
        IPropertyDescriptor[] descriptors = this.metadataPropertySource.getPropertyDescriptors();
        return Arrays.stream(descriptors).filter(d -> d.getDisplayName().equals(displayName)).findFirst().orElse(null);
    }

    private IStatus executeMetadataUpdate(IAdaptable info, Object value) {
        IStatus executionStatus = Status.CANCEL_STATUS;
        Shell shell = (Shell)info.getAdapter(Shell.class);
        if (this.featureId == null) {
            executionStatus = new Status(4, "org.eclipse.capra.ui", "Metadata field " + this.featureId + "not found");
            OperationsHelper.createErrorMessage(shell, executionStatus, ERROR_DIALOG_TITLE, "Metadata field " + this.featureId + "not found");
        } else {
            try {
                this.metadataPropertySource.setPropertyValue(this.featureId, value);
                executionStatus = Status.OK_STATUS;
            }
            catch (IllegalStateException e) {
                executionStatus = new Status(4, "org.eclipse.capra.ui", e.getMessage(), (Throwable)e);
                OperationsHelper.createErrorMessage(shell, executionStatus, ERROR_DIALOG_TITLE, e.getMessage());
            }
            catch (RuntimeException e) {
                executionStatus = new Status(4, "org.eclipse.capra.ui", e.getMessage(), (Throwable)e);
                OperationsHelper.createErrorMessage(shell, executionStatus, ERROR_DIALOG_TITLE, EXCEPTION_MESSAGE_RUNTIME_EXCEPTION);
            }
        }
        return executionStatus;
    }
}

