/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.handler.file;

import java.util.Collections;
import java.util.List;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.IArtifactMetaModelAdapter;
import org.eclipse.capra.core.handlers.AbstractArtifactHandler;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class FileHandler
extends AbstractArtifactHandler<IFile> {
    public EObject createWrapper(IFile file, EObject artifactModel) {
        IArtifactMetaModelAdapter adapter = (IArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactMetaModelAdapter().orElseThrow();
        String uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toPlatformString(false);
        return adapter.createArtifact(artifactModel, ((Object)((Object)this)).getClass().getName(), uri, null, file.getName());
    }

    public IFile resolveWrapper(EObject wrapper) {
        IArtifactMetaModelAdapter adapter = (IArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactMetaModelAdapter().orElseThrow();
        String uri = adapter.getArtifactUri(wrapper);
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri));
    }

    public boolean doesArtifactExist(EObject wrapper) {
        return this.resolveWrapper(wrapper).exists();
    }

    public String getDisplayName(IFile file) {
        return file.getName();
    }

    public String generateMarkerMessage(IResourceDelta delta, String wrapperUri) {
        return String.valueOf(delta.getResource().getName()) + " has been changed. Please check if associated trace links are still valid.";
    }

    public List<Connection> getInternalLinks(EObject investigatedElement, List<String> selectedRelationshipTypes, boolean reverseDirection) {
        return Collections.emptyList();
    }

    public boolean isThereAnInternalTraceBetween(EObject first, EObject second) {
        return false;
    }
}

