/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.actions;

import java.util.HashMap;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sqleditor.IPageUpdate;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.BaseExecuteAction;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ExecuteSelectionSQLAction
extends BaseExecuteAction
implements ISelectionChangedListener,
IPageUpdate {
    private SQLEditor _sqlEditor;
    private ITextSelection _selection;
    private boolean _isSourcePage = true;

    public ExecuteSelectionSQLAction(SQLEditor targetEditor) {
        this.setText(Messages.ExecuteSelectionSQLAction_label);
        this.setToolTipText(Messages.ExecuteSelectionSQLAction_tooltip);
        this.setImageDescriptor(SQLEditorResources.getImageDescriptor("sql_execute_selection"));
        this.setActionDefinitionId("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction");
        this.setId("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction");
        this.setActiveEditor(targetEditor);
        targetEditor.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.update();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, HelpUtil.getContextId((String)"execute_selected_text_action", (String)SQLEditorPlugin.getDefault().getBundle().getSymbolicName()));
    }

    public void setActiveEditor(SQLEditor targetEditor) {
        this._sqlEditor = targetEditor;
    }

    @Override
    public void run() {
        super.run();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this._sqlEditor);
    }

    public void update() {
        this.setEnabled(this._isSourcePage && this._sqlEditor != null && this._sqlEditor.isConnected() && this._sqlEditor.getSelectedText() != null);
    }

    @Override
    public String getSQLStatements() {
        return this._sqlEditor == null ? null : SQLToolsFacade.getDBHelper((DatabaseIdentifier)this.getDatabaseIdentifier()).preprocessSQLScript(this._sqlEditor.getSelectedText());
    }

    @Override
    public Runnable getPostRun() {
        Runnable postRun = new Runnable(){

            @Override
            public void run() {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)ExecuteSelectionSQLAction.this._sqlEditor);
            }
        };
        return postRun;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof ITextSelection) {
            this._selection = (ITextSelection)event.getSelection();
            this.update();
        }
    }

    @Override
    protected boolean promptVariable() {
        return true;
    }

    @Override
    protected HashMap getVariableDeclarations() {
        int start = 0;
        int length = 0;
        if (this._selection == null) {
            this._selection = (ITextSelection)this._sqlEditor.getSelectionProvider().getSelection();
        }
        if (this._selection != null && !this._selection.isEmpty()) {
            start = this._selection.getOffset();
            length = this._selection.getLength();
            if (length < 0) {
                length = -length;
                start -= length;
            }
        }
        int offset = length > 0 ? start + 1 : start;
        IDocument document = this._sqlEditor.getDocumentProvider().getDocument((Object)this._sqlEditor.getEditorInput());
        ParsingResult result = this._sqlEditor.getParsingResult();
        HashMap variables = null;
        if (result != null) {
            variables = result.getVariables(document, offset);
            HashMap sp_params = result.getParameters(document, offset);
            variables.putAll(sp_params);
        }
        return variables;
    }

    @Override
    protected SQLEditor getEditor() {
        return this._sqlEditor;
    }

    @Override
    public DatabaseIdentifier getDatabaseIdentifier() {
        if (this._sqlEditor != null) {
            String profileName = this._sqlEditor.getConnectionInfo().getConnectionProfileName();
            String dbName = this._sqlEditor.getConnectionInfo().getDatabaseName();
            return new DatabaseIdentifier(profileName, dbName);
        }
        return null;
    }

    @Override
    public void update(boolean isSQLEditorPage) {
        this._isSourcePage = isSQLEditorPage;
        this.update();
    }
}

