/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters097.utils;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.9.6"}, service={ICache.class, ComponentPortInterfaceCacheBuilder.class})
public class ComponentPortInterfaceCacheBuilder
implements ICache {
    @Reference
    SessionLogger logger;
    public static final String INTERFACE_CACHE_KEY = "ComponentPort_Interface_Names";
    public static final String INSTANCE_PARENT_CACHE_KEY = "ComponentInstance_Parent_Names";
    private final HashMap<File, Map<String, Object>> map = new HashMap();

    public void buildCache(Map<File, Document> fileDocumentMapping) {
        if (this.logger != null) {
            this.logger.info("Build up ComponentPortInterfaceCache for 0.9.6", new Object[0]);
        }
        HashSet<String> uniqueInterfaceNames = new HashSet<String>();
        HashMap<String, String> componentInstanceNames = new HashMap<String, String>();
        for (Map.Entry<File, Document> entry : fileDocumentMapping.entrySet()) {
            Document document1 = entry.getValue();
            if (document1 == null) continue;
            Element rootElement = document1.getRootElement();
            List componentPorts = HelperUtil.getXpathResult((Element)rootElement, (String)"./componentsModel/components/ports[@interfaceName]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_097, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
            for (Element port : componentPorts) {
                String attrVal = port.getAttributeValue("interfaceName");
                if (attrVal == null || attrVal.trim().length() <= 0) continue;
                uniqueInterfaceNames.add(attrVal.trim());
            }
            List componentInstances = HelperUtil.getXpathResult((Element)rootElement, (String)"./componentsModel/components/componentInstances", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_097, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
            for (Element componentInstance : componentInstances) {
                Element parentElement;
                String instanceName = componentInstance.getAttributeValue("name");
                if (instanceName == null || instanceName.trim().length() <= 0 || (parentElement = this.getParentElement(componentInstance)) == null) continue;
                Attribute name = parentElement.getAttribute("name");
                String parentName = name != null ? name.getValue() : "";
                componentInstanceNames.put(HelperUtil.encodeName((String)instanceName), HelperUtil.encodeName((String)parentName));
            }
        }
        HashMap<String, Cloneable> cache = new HashMap<String, Cloneable>();
        cache.put(INTERFACE_CACHE_KEY, uniqueInterfaceNames);
        cache.put(INSTANCE_PARENT_CACHE_KEY, componentInstanceNames);
        Map.Entry firstEntry = fileDocumentMapping.entrySet().stream().sorted((e1, e2) -> ((File)e1.getKey()).getName().compareTo(((File)e2.getKey()).getName())).findFirst().orElse(null);
        if (firstEntry != null) {
            File targetFile = (File)firstEntry.getKey();
            this.map.put(targetFile, cache);
        }
    }

    private Element getParentElement(Element element) {
        Attribute type;
        if (element == null || element.isRootElement()) {
            return null;
        }
        if ("systems".equals(element.getName())) {
            return element;
        }
        if ("components".equals(element.getName()) && (type = element.getAttribute("type", AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi"))) != null && "am:Composite".equals(type.getValue())) {
            return element;
        }
        return this.getParentElement(element.getParentElement());
    }

    public Collection<String> getCachedInterfaceNames() {
        Map<String, Object> interfaceMap;
        Collection interfaceNames;
        if (!this.map.isEmpty() && (interfaceNames = (Collection)(interfaceMap = this.map.values().iterator().next()).get(INTERFACE_CACHE_KEY)) != null) {
            return interfaceNames;
        }
        return new HashSet<String>();
    }

    public Map<String, String> getCachedComponentInstanceParentNames() {
        Map<String, Object> cacheMap;
        HashMap parentNames;
        if (!this.map.isEmpty() && (parentNames = (HashMap)(cacheMap = this.map.values().iterator().next()).get(INSTANCE_PARENT_CACHE_KEY)) != null) {
            return parentNames;
        }
        return new HashMap<String, String>();
    }

    public Map<File, Map<String, Object>> getCacheMap() {
        return this.map;
    }

    public void clearCacheMap() {
        this.map.clear();
    }
}

