/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters093.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters093.utils.HelperUtils_092_093;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.9.2", "output_model_version=0.9.3"}, service={IConverter.class})
public class MeasurementConverter
extends AbstractConverter {
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        this.logger.info("Migration from 0.9.2 to 0.9.3 : Executing Measurement converter for model file : {0}", new Object[]{targetFile.getName()});
        Document root = filename2documentMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateStimuli(rootElement);
    }

    private void updateStimuli(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./measurementModel/measurements");
        List measurementElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._093, (String)"am"), AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element measurementElement : measurementElements) {
            Element runtimeDeviation_Time_element = measurementElement.getChild("runtimeDeviation");
            if (runtimeDeviation_Time_element == null) continue;
            Element migratedElement = HelperUtils_092_093.migrateDeviationElementContainingTimeValue(runtimeDeviation_Time_element, "runtimeDeviation", this.logger);
            int indexOf = measurementElement.indexOf((Content)runtimeDeviation_Time_element);
            measurementElement.removeContent((Content)runtimeDeviation_Time_element);
            if (migratedElement == null) continue;
            measurementElement.addContent(indexOf, (Content)migratedElement);
        }
    }
}

