/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.migration.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.Comment;
import org.eclipse.acceleo.CommentBody;
import org.eclipse.acceleo.Error;
import org.eclipse.acceleo.ErrorComment;
import org.eclipse.acceleo.ErrorModuleDocumentation;
import org.eclipse.acceleo.ModuleDocumentation;

public class DocumentationParser {
    public static final String SLASH_END = "/]";
    public static final String COMMENT_START = "[comment ";
    public static final String COMMENT_END = "/]";
    public static final String MODULE_HEADER_START = "[module ";
    public static final String DOCUMENTATION_START = "[**";
    public static final String DOCUMENTATION_END = "/]";
    public static final String AUTHOR_TAG = "@author ";
    public static final String VERSION_TAG = "@version ";
    public static final String SINCE_TAG = "@since ";
    public static final String PARAM_TAG = "@param ";
    private int currentPosition;
    private String text;
    private List<Error> errors;

    public List<Comment> parse(String mtlContent) {
        this.currentPosition = 0;
        this.text = mtlContent;
        this.errors = new ArrayList<Error>();
        return this.parseCommentsOrModuleDocumentations();
    }

    protected List<Comment> parseCommentsOrModuleDocumentations() {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        Comment comment = this.parseComment();
        ModuleDocumentation documentation = this.parseModuleDocumentation();
        while (comment != null || documentation != null) {
            if (comment != null) {
                comments.add(comment);
            }
            if (documentation != null) {
                comments.add((Comment)documentation);
            }
            this.skipSpaces();
            comment = this.parseComment();
            documentation = this.parseModuleDocumentation();
        }
        return comments;
    }

    protected void skipSpaces() {
        while (this.currentPosition < this.text.length() && Character.isWhitespace(this.text.charAt(this.currentPosition))) {
            ++this.currentPosition;
        }
    }

    protected Comment parseComment() {
        Comment res;
        if (this.text.startsWith(COMMENT_START, this.currentPosition)) {
            int startOfCommentBody = this.currentPosition + COMMENT_START.length();
            int endOfCommentBody = this.text.indexOf("/]", startOfCommentBody);
            if (endOfCommentBody < 0) {
                endOfCommentBody = this.text.length();
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorComment();
                ((ErrorComment)res).setMissingEndHeader(endOfCommentBody);
                this.errors.add((Error)res);
                this.currentPosition = endOfCommentBody;
            } else {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createComment();
                this.currentPosition = endOfCommentBody + "/]".length();
            }
            CommentBody commentBody = AcceleoPackage.eINSTANCE.getAcceleoFactory().createCommentBody();
            commentBody.setValue(this.text.substring(startOfCommentBody, endOfCommentBody));
            res.setBody(commentBody);
        } else {
            res = null;
        }
        return res;
    }

    protected ModuleDocumentation parseModuleDocumentation() {
        ModuleDocumentation res;
        if (this.text.startsWith(DOCUMENTATION_START, this.currentPosition)) {
            this.currentPosition += DOCUMENTATION_START.length();
            int startPosition = this.currentPosition;
            int endPosition = this.text.indexOf("/]", this.currentPosition);
            if (endPosition < 0) {
                this.currentPosition = endPosition = this.text.length();
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createErrorModuleDocumentation();
                ((ErrorModuleDocumentation)res).setMissingEndHeader(endPosition);
                this.errors.add((Error)res);
            } else {
                res = AcceleoPackage.eINSTANCE.getAcceleoFactory().createModuleDocumentation();
                this.currentPosition = endPosition + "/]".length();
            }
            String docString = this.text.substring(startPosition, endPosition);
            CommentBody commentBody = AcceleoPackage.eINSTANCE.getAcceleoFactory().createCommentBody();
            commentBody.setValue(docString);
            res.setBody(commentBody);
        } else {
            res = null;
        }
        return res;
    }
}

