/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.gui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.group.command.CreateColumnGroupCommand;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateColumnGroupDialog
extends Dialog {
    private Button createButton;
    private Text groupNameText;
    private ILayer contextLayer;

    private CreateColumnGroupDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(67680);
        this.setBlockOnOpen(false);
    }

    public static CreateColumnGroupDialog createColumnGroupDialog(Shell shell) {
        return new CreateColumnGroupDialog(shell);
    }

    public void setContextLayer(ILayer layer) {
        this.contextLayer = layer;
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.getString("ColumnGroups.createColumnGroupDialogTitle"));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridDataFactory.fillDefaults().minSize(200, 100).align(4, 4).grab(true, false).applyTo((Control)this.createInputPanel(composite));
        Composite buttonPanel = this.createButtonSection(composite);
        GridDataFactory.swtDefaults().align(4, 1024).grab(true, true).applyTo((Control)buttonPanel);
        return composite;
    }

    private Composite createButtonSection(Composite composite) {
        Composite panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = 2;
        panel.setLayout((Layout)layout);
        this.createButton = this.createButton(panel, 1024, Messages.getString("ColumnGroups.createButtonLabel"), false);
        GridDataFactory.swtDefaults().align(131072, 1024).grab(true, true).applyTo((Control)this.createButton);
        this.createButton.setEnabled(false);
        this.getShell().setDefaultButton(this.createButton);
        this.createButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateColumnGroupDialog.this.doColumnGrouping();
            }
        });
        Button closeButton = this.createButton(panel, 1, Messages.getString("AbstractStyleEditorDialog.cancelButton"), false);
        GridDataFactory.swtDefaults().align(131072, 1024).grab(false, false).applyTo((Control)closeButton);
        return panel;
    }

    private Composite createInputPanel(Composite composite) {
        Composite row = new Composite(composite, 0);
        row.setLayout((Layout)new GridLayout(2, false));
        Label createLabel = new Label(row, 0);
        createLabel.setText(Messages.getString("ColumnGroups.createGroupLabel") + ":");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)createLabel);
        this.groupNameText = new Text(row, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.groupNameText);
        this.groupNameText.addModifyListener(e -> this.createButton.setEnabled(this.groupNameText.getText().length() > 0));
        this.groupNameText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (CreateColumnGroupDialog.this.createButton.isEnabled()) {
                    CreateColumnGroupDialog.this.doColumnGrouping();
                }
            }
        });
        return row;
    }

    public void terminateDialog() {
        this.close();
    }

    private void doColumnGrouping() {
        BusyIndicator.showWhile((Display)super.getShell().getDisplay(), () -> {
            CreateColumnGroupCommand command = new CreateColumnGroupCommand(this.groupNameText.getText());
            try {
                this.contextLayer.doCommand(command);
            }
            finally {
                this.terminateDialog();
            }
        });
    }
}

