/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.interactors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.deployment.IDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.Messages;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractorProvider;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public enum DeviceManagementInteractorFactory {
    INSTANCE;

    private static final String PLUGIN_ID = "org.eclipse.fordiac.ide.deployment";
    private List<IDeviceManagementInteractorProvider> deviceManagementInteractorProviders = null;

    public IDeviceManagementInteractor getDeviceManagementInteractor(Device device, IDeviceManagementCommunicationHandler overrideComHandler, String profile) {
        String profileToUse = profile != null ? profile : device.getProfile();
        for (IDeviceManagementInteractorProvider idepExec : this.getDeviceManagementInteractorList()) {
            if (!idepExec.supports(profileToUse)) continue;
            return idepExec.createInteractor(device, overrideComHandler);
        }
        return null;
    }

    public IDeviceManagementInteractor getDeviceManagementInteractor(Device device) {
        return this.getDeviceManagementInteractor(device, null, null);
    }

    public List<String> getAvailableProfileNames() {
        return this.getDeviceManagementInteractorList().stream().map(IDeviceManagementInteractorProvider::getProfileName).toList();
    }

    private List<IDeviceManagementInteractorProvider> getDeviceManagementInteractorList() {
        if (this.deviceManagementInteractorProviders == null) {
            this.deviceManagementInteractorProviders = DeviceManagementInteractorFactory.loadDeviceManagmentInteractors();
        }
        return this.deviceManagementInteractorProviders;
    }

    private static List<IDeviceManagementInteractorProvider> loadDeviceManagmentInteractors() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elems = registry.getConfigurationElementsFor(PLUGIN_ID, "devicemanagementinteractor");
        ArrayList<IDeviceManagementInteractorProvider> interactors = new ArrayList<IDeviceManagementInteractorProvider>(elems.length);
        IConfigurationElement[] iConfigurationElementArray = elems;
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Object object = element.createExecutableExtension("class");
                if (object instanceof IDeviceManagementInteractorProvider) {
                    IDeviceManagementInteractorProvider iDeviceManagementInteractorProvider = (IDeviceManagementInteractorProvider)object;
                    interactors.add(iDeviceManagementInteractorProvider);
                }
            }
            catch (CoreException corex) {
                FordiacLogHelper.logError((String)Messages.DeploymentCoordinator_ERROR_Message, (Throwable)corex);
            }
            ++n2;
        }
        return interactors;
    }
}

