/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.extender;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.extender.IDifferenceGroupExtender;

public class DifferenceGroupExtenderRegistryListener
extends AbstractRegistryEventListener {
    static final String TAG_GROUP_PROVIDER = "differenceGroupExtender";
    static final String ATT_CLASS = "class";
    private final IDifferenceGroupExtender.Registry extendersRegistry;

    public DifferenceGroupExtenderRegistryListener(String pluginID, String extensionPointID, ILog log, IDifferenceGroupExtender.Registry registry) {
        super(pluginID, extensionPointID, log);
        this.extendersRegistry = registry;
    }

    protected boolean validateExtensionElement(IConfigurationElement element) {
        boolean valid;
        if (element.getName().equals(TAG_GROUP_PROVIDER)) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
                valid = false;
            } else {
                valid = true;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    protected boolean addedValid(IConfigurationElement element) {
        try {
            IDifferenceGroupExtender extender = (IDifferenceGroupExtender)element.createExecutableExtension(ATT_CLASS);
            IDifferenceGroupExtender previous = this.extendersRegistry.add(extender);
            if (previous != null) {
                this.log(2, element, "The difference group extender '" + extender.getClass().getName() + "' is registered twice.");
            }
        }
        catch (CoreException e) {
            this.log(element, e);
            return false;
        }
        return true;
    }

    protected boolean removedValid(IConfigurationElement element) {
        this.extendersRegistry.remove(element.getAttribute(ATT_CLASS));
        return true;
    }
}

