/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.value.ValueConverter;

public class StructValueConverter
implements ValueConverter<Map<String, Object>> {
    static final Pattern STRUCT_BEGIN_PATTERN = Pattern.compile("\\G\\(\\s*+");
    static final Pattern STRUCT_END_PATTERN = Pattern.compile("\\G\\s*+\\)");
    static final Pattern STRUCT_SEPARATOR_PATTERN = Pattern.compile("\\G\\s*+,\\s*+");
    static final Pattern STRUCT_ASSIGNMENT_PATTERN = Pattern.compile("\\G(\\w++)\\s*+:=\\s*+");
    private final Function<String, ValueConverter<?>> memberValueConverter;

    public StructValueConverter(Function<String, ValueConverter<?>> memberValueConverter) {
        this.memberValueConverter = memberValueConverter;
    }

    @Override
    public Map<String, Object> toValue(String string) throws IllegalArgumentException {
        return this.toValue(new Scanner(string));
    }

    @Override
    public Map<String, Object> toValue(Scanner scanner) throws IllegalArgumentException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (scanner.findWithinHorizon(STRUCT_BEGIN_PATTERN, 0) == null) {
            throw new IllegalArgumentException(Messages.StructValueConverter_InvalidStructLiteral);
        }
        do {
            if (scanner.findWithinHorizon(STRUCT_ASSIGNMENT_PATTERN, 0) == null) {
                throw new IllegalArgumentException(Messages.StructValueConverter_InvalidStructLiteral);
            }
            String name = scanner.match().group(1);
            ValueConverter<?> converter = this.memberValueConverter.apply(name);
            if (converter == null) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.StructValueConverter_NoValueConverter, name));
            }
            try {
                result.put(name, converter.toValue(scanner));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.StructValueConverter_IllegalMemberValue, name), e);
            }
        } while (scanner.findWithinHorizon(STRUCT_SEPARATOR_PATTERN, 0) != null);
        if (scanner.findWithinHorizon(STRUCT_END_PATTERN, 0) == null) {
            throw new IllegalArgumentException(Messages.StructValueConverter_InvalidStructLiteral);
        }
        return result;
    }

    @Override
    public String toString(Map<String, Object> value) {
        return value.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> this.toString((String)entry.getKey(), entry.getValue())).collect(Collectors.joining(", ", "(", ")"));
    }

    private String toString(String name, Object value) {
        return name + " := " + this.memberValueConverter.apply(name).toString(value);
    }

    public String toString() {
        return String.format("%s [%s]", this.getClass().getSimpleName(), this.memberValueConverter);
    }
}

