/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.watch;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugDevice;
import org.eclipse.fordiac.ide.deployment.debug.Messages;
import org.eclipse.fordiac.ide.deployment.debug.watch.AbstractVariableWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchData;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchUtils;
import org.eclipse.fordiac.ide.deployment.devResponse.Data;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementExecutorService;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;

public abstract class AbstractRuntimeWatch
extends AbstractVariableWatch {
    private final String resourceRelativeName;

    protected AbstractRuntimeWatch(Variable<?> variable, ITypedElement element, DeploymentDebugDevice debugTarget) throws EvaluatorException {
        super(variable, element, debugTarget);
        this.resourceRelativeName = DeploymentDebugWatchUtils.getResourceRelativeName((INamedElement)element, this.getResource());
    }

    protected AbstractRuntimeWatch(Variable<?> variable, ITypedElement element, Resource resource, String resourceRelativeName, DeploymentDebugDevice debugTarget) throws EvaluatorException {
        super(variable, element, resource, debugTarget);
        this.resourceRelativeName = resourceRelativeName;
    }

    @Override
    public void addWatch() throws DebugException {
        Resource resource = this.getResource();
        if (resource == null) {
            return;
        }
        try {
            this.getDeviceManagementExecutorService().addWatch(resource, this.getResourceRelativeName());
        }
        catch (DeploymentException e) {
            throw new DebugException(Status.error((String)MessageFormat.format(Messages.AbstractRuntimeWatch_AddWatch, this.getQualifiedName()), (Throwable)e));
        }
    }

    @Override
    public void removeWatch() throws DebugException {
        Resource resource = this.getResource();
        if (resource == null) {
            return;
        }
        try {
            this.getDeviceManagementExecutorService().removeWatch(resource, this.getResourceRelativeName());
        }
        catch (DeploymentException e) {
            throw new DebugException(Status.error((String)MessageFormat.format(Messages.AbstractRuntimeWatch_RemoveWatch, this.getQualifiedName()), (Throwable)e));
        }
    }

    @Override
    public final void updateValue(DeploymentDebugWatchData watchData) {
        Resource resource = this.getResource();
        if (resource == null) {
            return;
        }
        Data data = watchData.getLastData(resource, this.getResourceRelativeName());
        if (data != null) {
            this.updateValue(data);
        }
    }

    protected void updateValue(Data data) {
        this.updateValue(data.getValue());
    }

    protected String getResourceRelativeName() {
        return this.resourceRelativeName;
    }

    protected IDeviceManagementExecutorService getDeviceManagementExecutorService() {
        return this.getDebugTarget().getDeviceManagementExecutorService();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

