/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.conflict;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.internal.conflict.AbstractConflictSearch;
import org.eclipse.emf.compare.internal.conflict.ComparisonIndex;
import org.eclipse.emf.compare.utils.EMFCompareJavaPredicates;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AttributeChangeConflictSearch {

    public static class Add
    extends AbstractConflictSearch<AttributeChange> {
        public Add(AttributeChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            EAttribute feature = ((AttributeChange)this.diff).getAttribute();
            Object value = ((AttributeChange)this.diff).getValue();
            EList<Diff> diffsInSameMatch = ((AttributeChange)this.diff).getMatch().getDifferences();
            Iterable conflictCandidates = diffsInSameMatch.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(AttributeChange.class::isInstance).and(EMFCompareJavaPredicates.onFeature((EStructuralFeature)feature)).and(EMFCompareJavaPredicates.ofKind(DifferenceKind.ADD)))::iterator;
            if (feature.isUnique()) {
                for (Diff candidate : conflictCandidates) {
                    Object candidateValue = ((AttributeChange)candidate).getValue();
                    if (!this.comparison.getEqualityHelper().matchingValues(value, candidateValue)) continue;
                    FeatureFilter featureFilter = this.getFeatureFilter(this.comparison);
                    if (featureFilter == null || featureFilter.checkForOrderingChanges((EStructuralFeature)feature)) {
                        if (MatchUtil.matchingIndices(((AttributeChange)this.diff).getMatch(), (EStructuralFeature)feature, value, candidateValue)) {
                            this.conflict(candidate, ConflictKind.PSEUDO);
                            continue;
                        }
                        this.conflict(candidate, ConflictKind.REAL);
                        continue;
                    }
                    this.conflict(candidate, ConflictKind.PSEUDO);
                }
            } else {
                for (Diff candidate : conflictCandidates) {
                    Object candidateValue = ((AttributeChange)candidate).getValue();
                    if (!this.comparison.getEqualityHelper().matchingValues(value, candidateValue)) continue;
                    if (candidate.getConflict() != null && candidate.getConflict().getKind() == ConflictKind.PSEUDO) {
                        if (candidate.getConflict().getDifferences().stream().filter(AttributeChange.class::isInstance).anyMatch(conflictingWith -> this.matchingConflictingDiff((AttributeChange)this.diff, (AttributeChange)conflictingWith))) continue;
                    }
                    this.conflict(candidate, ConflictKind.PSEUDO);
                    break;
                }
            }
        }

        private boolean matchingConflictingDiff(AttributeChange reference, AttributeChange candidate) {
            if (reference == candidate) {
                return false;
            }
            if (reference.getMatch() == candidate.getMatch() && reference.getKind() == candidate.getKind()) {
                Object referenceValue = reference.getValue();
                Object candidateValue = candidate.getValue();
                return this.comparison.getEqualityHelper().matchingValues(referenceValue, candidateValue);
            }
            return false;
        }
    }

    public static class Change
    extends AbstractConflictSearch<AttributeChange> {
        public Change(AttributeChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            Object value = ((AttributeChange)this.diff).getValue();
            EAttribute feature = ((AttributeChange)this.diff).getAttribute();
            EList<Diff> diffsInSameMatch = ((AttributeChange)this.diff).getMatch().getDifferences();
            Iterable candidates = diffsInSameMatch.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(AttributeChange.class::isInstance).and(EMFCompareJavaPredicates.onFeature((EStructuralFeature)feature)).and(EMFCompareJavaPredicates.ofKind(DifferenceKind.CHANGE)))::iterator;
            for (Diff candidate : candidates) {
                Object candidateValue = ((AttributeChange)candidate).getValue();
                if (this.comparison.getEqualityHelper().matchingValues(value, candidateValue)) {
                    this.conflict(candidate, ConflictKind.PSEUDO);
                    continue;
                }
                if (this.isFeatureMapChangeOrMergeableStringAttributeChange(this.diff, candidate)) continue;
                this.conflict(candidate, ConflictKind.REAL);
            }
        }
    }

    public static class Delete
    extends AbstractConflictSearch<AttributeChange> {
        public Delete(AttributeChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            Object value = ((AttributeChange)this.diff).getValue();
            EAttribute feature = ((AttributeChange)this.diff).getAttribute();
            EList<Diff> diffsInSameMatch = ((AttributeChange)this.diff).getMatch().getDifferences();
            Iterable candidates = diffsInSameMatch.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(AttributeChange.class::isInstance).and(EMFCompareJavaPredicates.onFeature((EStructuralFeature)feature)).and(EMFCompareJavaPredicates.ofKind(DifferenceKind.MOVE, DifferenceKind.DELETE)))::iterator;
            for (Diff candidate : candidates) {
                Object candidateValue = ((AttributeChange)candidate).getValue();
                if (!this.comparison.getEqualityHelper().matchingValues(value, candidateValue)) continue;
                if (candidate.getKind() == DifferenceKind.MOVE) {
                    this.conflict(candidate, ConflictKind.REAL);
                    continue;
                }
                if (((AttributeChange)this.diff).getMatch() != candidate.getMatch()) continue;
                this.conflict(candidate, ConflictKind.PSEUDO);
            }
        }
    }

    public static class Move
    extends AbstractConflictSearch<AttributeChange> {
        public Move(AttributeChange diff, ComparisonIndex index, Monitor monitor) {
            super(diff, index, monitor);
        }

        @Override
        public void detectConflicts() {
            Object value = ((AttributeChange)this.diff).getValue();
            EAttribute feature = ((AttributeChange)this.diff).getAttribute();
            EList<Diff> diffsInSameMatch = ((AttributeChange)this.diff).getMatch().getDifferences();
            Iterable candidates = diffsInSameMatch.stream().filter(EMFCompareJavaPredicates.possiblyConflictingWith(this.diff).and(AttributeChange.class::isInstance).and(EMFCompareJavaPredicates.onFeature((EStructuralFeature)feature)).and(EMFCompareJavaPredicates.ofKind(DifferenceKind.MOVE)))::iterator;
            for (Diff candidate : candidates) {
                Object candidateValue = ((AttributeChange)candidate).getValue();
                if (!this.comparison.getEqualityHelper().matchingAttributeValues(value, candidateValue)) continue;
                if (MatchUtil.matchingIndices(((AttributeChange)this.diff).getMatch(), (EStructuralFeature)feature, value, candidateValue)) {
                    this.conflict(candidate, ConflictKind.PSEUDO);
                    continue;
                }
                this.conflict(candidate, ConflictKind.REAL);
            }
        }
    }
}

