---
stage: Secure
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Insecure authentication over HTTP (Basic Authentication)

## Description

The target application was found to authenticate users using the Basic Authentication scheme over HTTP.
Basic Authentication base64 encodes the username and password and sends it in the `Authentication` header.
Attackers who are in between the communication path (or on the same local network) of the client and server
could use packet sniffers to read and decode the username and password.

## Remediation

If possible, switch to a more robust method to authenticate users such as OAuth 2.0, or storing usernames
and passwords in a data store protected by the Argon2id algorithm. If Basic Authentication must be used,
ensure credentials are only transmitted over secure channels such as HTTPS/TLS.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 287.1 | false | 287 | Passive | Medium |

## Links

- [OWASP](https://cheatsheetseries.owasp.org/cheatsheets/Password_Storage_Cheat_Sheet.html)
- [OAuth 2.0](https://oauth.net/2/)
- [CWE-287](https://cwe.mitre.org/data/definitions/287.html)
- [RFC](https://datatracker.ietf.org/doc/html/rfc7617)
