# frozen_string_literal: true

class PrepareIndexVulnerabilityFindingLinksOnProjectId < Gitlab::Database::Migration[2.2]
  milestone '17.3'
  disable_ddl_transaction!

  INDEX_NAME = 'index_vulnerability_finding_links_on_project_id'

  def up
    prepare_async_index :vulnerability_finding_links, :project_id, name: INDEX_NAME
  end

  def down
    unprepare_async_index :vulnerability_finding_links, INDEX_NAME
  end
end
