---
stage: Secure
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Exposure of sensitive information to an unauthorized actor (private IP address)

## Description

A private RFC 1918/RFC 4193 address was identified in the target application. Public facing websites should not be issuing
requests to private IP Addresses. Attackers attempting to execute subsequent attacks, such as Server-Side
Request Forgery (SSRF), may be able to use this information to identify additional internal targets.

## Remediation

Identify the resource that is incorrectly specifying an internal IP address and replace it with it's public
facing version, or remove the reference from the target application.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 200.1 | true | 200 | Passive | Low |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/200.html)
- [RFC](https://datatracker.ietf.org/doc/html/rfc1918)
- [RFC](https://datatracker.ietf.org/doc/html/rfc4193)
