---
stage: Create
group: Editor Extensions
description: Visual Studio Code, JetBrains, Neovim, GitLab CLI.
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Editor and IDE extensions

GitLab has plugins and extensions to extend GitLab functionality to the following editors:

- [Visual Studio Code](visual_studio_code/index.md)
- [JetBrains IDEs](jetbrains_ide/index.md)
- [Visual Studio](visual_studio/index.md)
- [Neovim](neovim/index.md)

GitLab also supports developers in their command-line interface with [`glab`](gitlab_cli/index.md) the GitLab CLI.

## Features

A complete list of the features and capabilities of each extension can be found in the documentation home for each extension.

## Related topics

- [How we created a GitLab Workflow Extension for VS Code](https://about.gitlab.com/blog/2020/07/31/use-gitlab-with-vscode/)
- [GitLab for Visual Studio](https://about.gitlab.com/blog/2023/06/29/gitlab-visual-studio-extension/)
- [GitLab for JetBrains and Neovim](https://about.gitlab.com/blog/2023/07/25/gitlab-jetbrains-neovim-plugins/)
- [Put `glab` at your fingertips with the GitLab CLI](https://about.gitlab.com/blog/2022/12/07/introducing-the-gitlab-cli/)
