/* Library libcerf:
 *   Compute complex error functions, based on a new implementation of
 *   Faddeeva's w_of_z. Also provide Dawson and Voigt functions.
 *
 * File erfcx.c:
 *   Test the function erfcx.
 *
 * Copyright:
 *   (C) 2025 Forschungszentrum Jülich GmbH
 *
 * Licence:
 *   ../LICENSE
 *
 * Authors:
 *   Joachim Wuttke, Forschungszentrum Jülich, 2013
 *
 * Website:
 *   http://apps.jcns.fz-juelich.de/libcerf
 *
 * Revision history:
 *   ../CHANGELOG
 */

#ifdef __cplusplus
#include <cassert>
#else
#include <assert.h>
#endif
#include <math.h>
#include <stdio.h>
#include "cerf.h"

#include "auto_test_erfcx.c" // Generated by the PPAPP code generator.

int test_one(double x, double fref)
{
    double fappr = erfcx(x);
    double relerr = fabs((fappr-fref) / fref) / pow(2.,-53);
    if (relerr > ppapp_maxrelerr) {
        printf("x=%23.16e -> fref=%23.16e fappr=%23.16e relerr/eps=%8g tol=%8g\n",
               x, fref, fappr, relerr, ppapp_maxrelerr);
        return 1;
    }
    return 0;
}

//! Program run_computation.
//! Writes a table of some representative x and f(x), the latter computed in polynomial approximation.

int main(void) {
    int failed = run_tests();
    if (failed) {
        printf("test_computation: %d test cases failed\n", failed);
        return 1;
    }
    return 0;
}
