## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----fromGithub, message=FALSE------------------------------------------------
# BiocManager::install("RFLOMICS/RFLOMICS")

## ----loadRflomics, message=FALSE----------------------------------------------
library(RFLOMICS)

## ----runInterface-------------------------------------------------------------
# runRFLOMICS()

## ----fig.show="hold", out.width="40%", fig.align = "center", echo=FALSE-------
knitr::include_graphics(c("Images/00_completeDesign.png","Images/00_nonBalancedDesign.png"))

## -----------------------------------------------------------------------------
data("ecoseed.mae")

## -----------------------------------------------------------------------------
factorInfo <- data.frame(
  "factorName"   = c("Repeat", "temperature", "imbibition"),
  "factorType"   = c("batch", "Bio", "Bio")
)

## ----createRMAE---------------------------------------------------------------
testObject <- createRflomicsMAE(
  projectName = "VignetteProject",
  omicsData   = ecoseed.mae,
  omicsTypes  = c("RNAseq","proteomics","metabolomics"),
  factorInfo  = factorInfo
)

## -----------------------------------------------------------------------------
class(testObject)

## -----------------------------------------------------------------------------
is(testObject, "MultiAssayExperiment")

## -----------------------------------------------------------------------------
upsetSamples(testObject)

## -----------------------------------------------------------------------------
sessionInfo()

