### Name: predict.Krig
### Title: Evaluation of Krig spatial process estimate.
### Aliases: predict.Krig
### Keywords: spatial

### ** Examples

Krig(ozone$x,ozone$y,exp.cov, theta=50) ->fit
predict( fit) # gives predicted values at data points

grid<- make.surface.grid( list( seq( -40,40,,15), seq( -40,40,,15)))

look<- predict(fit,grid) # evaluate on a grid of points

# some useful graphing functions
out.p<- as.surface( grid, look) # reformat into $x $y $z image-type object
contour( out.p)  

# refit with 10 degrees of freedom in surface

look<- predict(fit,grid, df=15)

# re fit with random data and lambda found by GCV
look<- predict( fit, grid, y= rnorm( 20), gcv=TRUE)

# NOTE: look is a list now  look$predicted  predicted values and look$lambda
# the value of lambda

out.p<-as.surface( grid, look$predicted) 
contour( out.p)



