### Name: Krig
### Title: Kriging surface estimate
### Aliases: Krig
### Keywords: spatial

### ** Examples

#2-d example 
# fitting a surface to ozone  
# measurements. Range parameter is 10 (in miles) 

fit <- Krig(ozone$x, ozone$y, exp.cov, theta=10)  
 
summary( fit) # summary of fit 
plot(fit) # diagnostic plots of fit  
surface( fit, type="C") # look at the surface 
out.p<- predict.surface.se( fit) 
image(out.p)

# predict at data

predict( fit)

# predict on a grid ( grid chosen here by defaults)
out<- predict.surface( fit)
persp( out)

# predict at arbitrary points (10,-10) and (20, 15)
xnew<- rbind( c( 10, -10), c( 20, 15))
predict( fit, xnew)

# standard errors of prediction based on covariance model.  
predict.se( fit, xnew)

#
# Roll your own: using a user defined Gaussian covariance 
#
test.cov <- function(x1,x2,theta){exp(-(rdist(x1,x2)/theta)**2)} 
# use this and put in quadratic polynomial fixed function 
fit.flame<- Krig(flame$x, flame$y, test.cov, m=3, theta=.5)
#
# note how range parameter is passed to Krig.   
# BTW:  GCV indicates an interpolating model (nugget variance is zero) 
#
# take a look ...
surface(fit.flame, type="I") 

# 
# Thin plate spline fit to ozone data using the radial 
# basis function as a generalized covariance function 
#
# p=2 is the power in the radial basis function (with a log term added for 
# even dimensions)
# If m is the degree of derivative in penalty then p=2m-d 
# where d is the dimension of x. p must be greater than 0. 
#  In the example below p = 2*2 - 2 = 2  
#
# See also the Fields function Tps

out<- Krig( ozone$x, ozone$y, rad.cov, m=2,  p=2, 
scale.type="range",decomp="WBW") # these last two options make sure the
                                 # the results with Tps are identical
# A Knot example

data(ozone2)
y16<- ozone2$y[16,] # there are some missing values! 
good<- !is.na( y16)
y<- y16[good] # Krig does not remove missing values. 
x<- ozone2$lon.lat[ good,]

#
# the knots can be arbitrary but just for fun find them with a space 
# filling design. Here we select  50 from the full set of 147 points
#
xknots<- cover.design( x, 50)$design # select 50 knot points

out<- Krig( x, y, knots=xknots,  rad.cov, m=2,  p=2,scale.type="range")

# Zee plot 
surface( out, type="C")
US( add=TRUE)
points( x, col=2)
points( xknots, cex=2, pch="O")

summary( out)
#
# note that that trA found by GCV is around 15 so 50>15  knots may be a 
# reasonable approximation to the full estimator. 
#
surface( out, type='C')
# obs and knots
points( x)
points( xknots, col=2)

# Correlation model example

# fit krig surface using a mean and sd function to standardize 
# first get stats from 1987 summer Midwest O3 data set 
# Compare the function Tps to the call to Krig given above 
# fit tps surfaces to the mean and sd  points.  
# (a shortcut is being taken here just using the lon/lat coordinates) 
data(ozone2)
stats.o3<- stats( ozone2$y)
mean.o3<- Tps( ozone2$lon.lat, c( stats.o3[2,]))
sd.o3<- Tps(  ozone2$lon.lat, c( stats.o3[3,]))

# Now use these to fit particular day ( day 16) 

y16<- ozone2$y[16,] # there are some missing values! 
good<- !is.na( y16) 
 
fit<- Krig( ozone2$lon.lat[good,], y16[good],exp.earth.cov, theta=353, 
mean.obj=mean.o3, sd.obj=sd.o3)
#
# the finale
surface( fit, type="I")
US( add=TRUE)
title("Estimated ozone surface")

  



